<?php
/*
 * $Id: backend_weblog.php,v 1.1 2003/08/29 13:15:39 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

require('mainfile.php');
require_once(XOOPS_ROOT_PATH.'/class/template.php');

// Include our module's language file
if ( file_exists(XOOPS_ROOT_PATH.'/modules/weblog/language/'.$xoopsConfig['language'].'/main.php') ) {
  require_once(XOOPS_ROOT_PATH.'/modules/weblog/language/'.$xoopsConfig['language'].'/main.php');
  require_once(XOOPS_ROOT_PATH.'/modules/weblog/language/'.$xoopsConfig['language'].'/modinfo.php');
} else {
  require_once(XOOPS_ROOT_PATH.'/modules/weblog/language/english/main.php');
  require_once(XOOPS_ROOT_PATH.'/modules/weblog/language/english/modinfo.php');
}

$max = 10;

header ('Content-Type:text/xml; charset=utf-8');
$tpl = new XoopsTpl();
$tpl->xoops_setTemplateDir(XOOPS_ROOT_PATH.'/themes');
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(10);

// Query for the given information
$user_id = !empty($_GET['user_id']) ? $_GET['user_id'] : 0;
$sql = 'SELECT blog_id,created,title FROM '.$xoopsDB->prefix('weblog')." WHERE private = 'N'";

// Limit by user?
if (!empty($user_id)) {
  $sql .= ' AND user_id = '.$user_id;
  
  $owner = new XoopsUser($user_id);
  $whosBLog = sprintf(_BL_WHOS_BLOG, $owner->getVar('uname','E'));
  $description = sprintf(_BL_ENTRIES_FOR, $owner->getVar('uname','E'));
  $link = XOOPS_URL.'/modules/weblog/index.php?user_id='.$user_id;
} else {
  // No, we must just be getting the last $max entries
  $whosBLog = $xoopsConfig['sitename'];
  $description = $xoopsConfig['slogan'];
  $link = XOOPS_URL.'/';
}

$tpl->assign('channel_title', xoops_convert_encoding(htmlspecialchars($whosBLog, ENT_QUOTES)));
$tpl->assign('channel_link', XOOPS_URL.'/');
$tpl->assign('channel_desc', xoops_convert_encoding(htmlspecialchars($description, ENT_QUOTES)));
$tpl->assign('channel_lastbuild', formatTimestamp(time(), 'rss'));
$tpl->assign('channel_webmaster', $xoopsConfig['adminmail']);
$tpl->assign('channel_editor', $xoopsConfig['adminmail']);
$tpl->assign('channel_category', _BL_BLOG);
$tpl->assign('channel_generator', _MI_WEBLOG_NAME.' v1.02');
$tpl->assign('channel_language', _LANGCODE);
$tpl->assign('image_url', XOOPS_URL.'/images/logo.gif');
$dimention = getimagesize(XOOPS_ROOT_PATH.'/images/logo.gif');
if (empty($dimention[0])) {
  $width = 88;
} else {
  $width = ($dimention[0] > 144) ? 144 : $dimention[0];
}
if (empty($dimention[1])) {
  $height = 31;
} else {
    $height = ($dimention[1] > 400) ? 400 : $dimention[1];
}
$tpl->assign('image_width', $width);
$tpl->assign('image_height', $height);

$sql .= ' ORDER BY created DESC';

$result=$xoopsDB->query($sql);
while(list($blog_id,$created,$title)=$xoopsDB->fetchRow($result))
{
  $item['title'] = xoops_convert_encoding(htmlspecialchars($title, ENT_QUOTES));
  $item['link'] = XOOPS_URL.'/modules/weblog/details.php?blog_id='.$blog_id;
  $item['guid'] = XOOPS_URL.'/modules/weblog/details.php?blog_id='.$blog_id;
  $item['pubdate'] = formatTimestamp($created, 'rss');

  /*
   * Need to learn how to chop off BCode properly so I can take the first 100 bytes
   * of an entry for the description. But I am afraid if the first 100 bytes would
   * look something like:
   *
   * Hello, this is my [b]fir...
   *
   * If I chop it there, what will happen?
   */
  $item['description'] = xoops_convert_encoding(htmlspecialchars('', ENT_QUOTES));
  $tpl->append('items', $item);
}

$tpl->display('db:weblog_rss.html');
?>
