<?php
/**
 * $Id: archive.php,v 1.1 2003/08/29 13:43:58 wellwine Exp $
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.zive.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place
 */

include ('header.php');

$xoopsOption['template_main'] = 'weblog_archive.html';
if (file_exists(XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/calendar.php')) {
  require_once(XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/calendar.php');
} else {
  require_once(XOOPS_ROOT_PATH.'/language/english/calendar.php');
}

//error_reporting(E_ALL);
$lastyear = 0;
$lastmonth = 0;

$months_arr = array(1 => _CAL_JANUARY, 2 => _CAL_FEBRUARY, 3 => _CAL_MARCH, 4 => _CAL_APRIL, 5 => _CAL_MAY, 6 => _CAL_JUNE,
    7 => _CAL_JULY, 8 => _CAL_AUGUST, 9 => _CAL_SEPTEMBER, 10 => _CAL_OCTOBER, 11 => _CAL_NOVEMBER, 12 => _CAL_DECEMBER);

$fromyear = (isset($_GET['year'])) ? intval ($_GET['year']): 0;
$frommonth = (isset($_GET['month'])) ? intval($_GET['month']) : 0;


// Determine the user we are retrieving the blog entries for
$user_id = !empty($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if (!empty($xoopsUser)) {
    $isAdmin = $xoopsUser->isAdmin($xoopsModule->mid());
    $currentuid = $xoopsUser->getVar('uid','E');
    $tz = $xoopsUser->timezone();
    if (isset($tz)) {
        $useroffset = $xoopsConfig['default_TZ']; //$tz;
    } else {
        $useroffset = $xoopsConfig['default_TZ'];
    }
} else {
    $isAdmin = false;
    $currentuid = 0;
    $useroffset = $xoopsConfig['default_TZ'];
}

$sql = 'SELECT bl.created FROM '.
    $xoopsDB->prefix('weblog').' as bl, '.
    $xoopsDB->prefix('users').' as u '.
    "WHERE (bl.private = 'N' OR bl.user_id='".$currentuid."') AND bl.user_id=u.uid ";

// For specific author archive
if ($user_id > 0) {
    $sql .= " AND bl.user_id='$user_id' ";
    $blogOwner=new XoopsUser($user_id);
    $page_subtitle = sprintf(_BL_ARCHIVE_FOR, $blogOwner->getVar('uname','E'));
} else {
    $page_subtitle = _BL_ARCHIVE;
}

$sql .= " ORDER BY bl.created ASC";  // assumes listed horizontally

// construct the page
// Include the page header
include(XOOPS_ROOT_PATH.'/header.php');

// if one or more records matched
if ($xoopsDB->getRowsNum($result = $xoopsDB->query($sql)) > 0) {
    $xoopsTpl->assign('show_archives', true);

    $years = array();
    $months = array();
    $i = 0;
    $this_year = 0;
    while (list($created) = $xoopsDB->fetchRow($result)) {
        $time = formatTimestamp($created, "mysql", $useroffset);
        if (preg_match("/([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})/", $time, $datetime)) {
            $this_year  = intval($datetime[1]);
            $this_month = intval($datetime[2]);
            if (empty($lastyear)) {
                $lastyear = $this_year;
            }
            if ($lastmonth == 0) {
                $lastmonth = $this_month;
                $months[$lastmonth]['string'] = $months_arr[$lastmonth];
                $months[$lastmonth]['number'] = $lastmonth;
            }
            if ($lastyear != $this_year) {
                $years[$i]['number'] = $lastyear;
                $years[$i]['months'] = $months;
                $months = array();
                $lastmonth = 0;
                $lastyear = $this_year;
                $i++;
            }
            if ($lastmonth != $this_month) {
                $lastmonth = $this_month;
                $months[$lastmonth]['string'] = $months_arr[$lastmonth];
                $months[$lastmonth]['number'] = $lastmonth;
            }
        }
    }
    $xoopsTpl->assign('show_archives', true);
    $years[$i]['number'] = $this_year;
    $years[$i]['months'] = $months;
    $xoopsTpl->assign('years', $years);
    $xoopsTpl->assign('user_id', $user_id);

    // List blog entries if year and month are spcified
    if ($fromyear != 0 && $frommonth != 0) {
        $xoopsTpl->assign('show_blogs', true);
        $xoopsTpl->assign('lang_title', _BL_TITLE);
        $xoopsTpl->assign('currentmonth', $months_arr[$frommonth]);
        $xoopsTpl->assign('currentyear', $fromyear);
        $xoopsTpl->assign('lang_date', _BL_POSTED);
        $xoopsTpl->assign('lang_author', _BL_AUTHOR);
        $xoopsTpl->assign('lang_reads', _BL_READS);
        $xoopsTpl->assign('lang_comments', _BL_T_COMMENTS);

        // must adjust the selected time to server timestamp
        $timeoffset = $useroffset - $xoopsConfig['server_TZ'];
        $monthstart = mktime(0 - $timeoffset, 0, 0, $frommonth, 1, $fromyear);
        $monthend = mktime(23 - $timeoffset, 59, 59, $frommonth + 1, 0, $fromyear);
        $monthend = ($monthend > time()) ? time() : $monthend;

        $sql = 'SELECT bl.comments,bl.blog_id,bl.created, bl.user_id, u.uname,'.
            'bl.title, bl.contents, bl.private, bl.reads '.
            'FROM '.
            $xoopsDB->prefix('weblog').' as bl, '.
            $xoopsDB->prefix('users').' as u '.
            "WHERE (bl.private = 'N' OR bl.user_id='".$currentuid."') AND bl.user_id=u.uid ".
            "AND bl.created > $monthstart AND bl.created < $monthend";

        if ($user_id > 0) {
            $sql .= " AND bl.user_id='$user_id' ";
        }

        $sql .= " ORDER BY bl.created DESC ";

        $result = $xoopsDB->query($sql);
        $count = 0;
        while(list($comments,$blog_id,$created,$uid,$uname,$title,
            $contents,$private,$reads)=$xoopsDB->fetchRow($result)) {
            $entry = array();
            $entry['title'] = "<a href='detail.php?blog_id=".$blog_id."'>".$title."</a>";
            $entry['reads'] = $reads;
            $entry['date'] = formatTimestamp($created, $xoopsModuleConfig['dateformat'], $useroffset);
            $entry['time'] = formatTimestamp($created, $xoopsModuleConfig['timeformat'], $useroffset);
            $entry['uid'] = $uid;
            $entry['uname'] = $uname;
            $entry['title'] = $title;
            $entry['profileUrl'] = XOOPS_URL.'/userinfo.php?uid='.$uid;
            $entry['blog_id'] = $blog_id;
            $entry['comments'] = $comments;
            $xoopsTpl->append('entries', $entry);
            $count++;
        }
        $xoopsTpl->assign('lang_blogtotal', sprintf(_BL_THEREAREINTOTAL, $count));
    } else {
    	$xoopsTpl->assign('show_blogs', false);
    }

} else {
    $xoopsTpl->assign('show_archives', false);
    $xoopsTpl->assign('lang_noarchives', _BL_NOARCHIVEDESC);
}
$xoopsTpl->assign('page_title', $xoopsModule->name());
$xoopsTpl->assign('page_subtitle', $page_subtitle);

include XOOPS_ROOT_PATH."/footer.php";
?>