<?php
/**
 * [ToDo]
 * 1) We may have to move this file to other module with following namespace or
 *    package.
 * 2) Some users and developers want free elements at $params. For example,
 *    $params['script']... This function have not impletented that yet. At
 *    implementing, we will have to define the rule about sanitizing.
 * 
 * @version $Id: function.xoops_textarea.php,v 1.1.2.4 2006/07/01 04:20:24 minahito Exp $
 */

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_textarea
 * Version:  1.0
 * Date:     Nov 2, 2005
 * Author:   minahito
 * Purpose:  textarea tag with sanitize.
 * Input:    name = form 'name'.
 *           value = preset value. Set raw value without htmlspecialchars().
 *           class = form 'class'.
 *           id = form 'id'. If it's empty, ID is defined automatically by prefix & name.
 *           cols = amount of cols. (default 50)
 *           rows = amount of rows. (default 5)
 *           readonly = if it's true, textarea becomes readonly.
 * 
 * Examples: {xoopsdhtmltarea name=message cols=40 rows=6 value=$message}
 * -------------------------------------------------------------
 */

define ("XOOPS_TEXTAREA_DEFID_PREFIX", "legacy_xoopsform_");
define ("XOOPS_TEXTAREA_DEFAULT_COLS", "50");
define ("XOOPS_TEXTAREA_DEFAULT_ROWS", "5");

function smarty_function_xoops_textarea($params, &$smarty)
{
	if (isset($params['name'])) {
		//
		// Fetch major elements from $params.
		//
		$name = trim($params['name']);
		$class = isset($params['class']) ? trim($params['class']) : null;
		$cols = isset($params['cols']) ? intval($params['cols']) : XOOPS_TEXTAREA_DEFAULT_COLS;
		$rows = isset($params['rows']) ? intval($params['rows']) : XOOPS_TEXTAREA_DEFAULT_ROWS;
		$value = isset($params['value']) ? htmlspecialchars($params['value'], ENT_QUOTES) : null;
		$id = isset($params['id']) ? trim($params['id']) : XOOPS_TEXTAREA_DEFID_PREFIX . $name;
		$readonly = isset($params['readonly']) ? trim($params['readonly']) : null;

		//
		// Build string.
		//
		$string = "<textarea name=\"${name}\" cols=\"${cols}\" rows=\"${rows}\"";
		
		if ($class) {
			$string .= " class=\"${class}\"";
		}

		$string .= " id=\"$id\"";
		
		if($readonly == 1) {
			$string .= " readonly=\"readonly\"";
		}

		$string .= " />" . $value . "</textarea>";

		//
		// Output.
		//
		print $string;
	}
}

?>
