<?php
/**
 * @package Legacy
 * @version $Id: BlockInstallEditAction.class.php,v 1.1.2.3 2006/08/01 10:29:20 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/admin/actions//BlockEditAction.class.php";

require_once XOOPS_MODULE_PATH . "/base/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/forms/BlockInstallEditForm.class.php";

class Legacy_BlockInstallEditAction extends Legacy_BlockEditAction
{
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_BlockInstallEditForm();
		$this->mActionForm->prepare();
	}
	
	function _isEditable()
	{
		if (is_object($this->mObject)) {
			return ($this->mObject->get('visible') == 0);
		}
		else {
			return false;
		}
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		parent::executeViewInput($controller, $xoopsUser, $render);
		$render->setTemplateName("blockinstall_edit.html");
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=BlockInstallList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=BlockInstallList", 1, _AD_BASE_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=BlockInstallList");
	}
}

?>
