<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/XCube_Service.class.php";

/**
 * Sample class
 */
class Legacy_SearchService extends XCube_Service
{
	function prepare()
	{
		$this->register('GetItems');
	}
	
	/**
	 * @param $parameters['uid'] Target user's id
	 * @param $parameters['current_uid'] Current user's id
	 * @param $parameters['maxhit'] Max hit count of each modules. The default value is 5.
	 * @param $parameters['mid'] If this is specified, search only one module.
	 */
	function GetItems($uid = 0, $current_uid = 0, $queries = null, $andor = null, $max_hit = 5, $start = null, $mids = null)
	{
		$ret = array();

		$uid = intval($uid);
		$current_uid = intval($current_uid);
				
		if ($andor == null) {
			$andor == "AND";
		}
		
		$userHandler =& xoops_gethandler('user');
		$currentUser =& $userHandler->get($current_uid);
		
		$gpermHandler = & xoops_gethandler( 'groupperm' );
		$groups = is_object($currentUser) ? $currentUser->getGroups() : XOOPS_GROUP_ANONYMOUS;

		//
		// At first, get active module IDs.
		//
		$moduleHandler =& xoops_gethandler('module');
		
		if (!is_array($mids) || (is_array($mids) && count($mids) == 0)) {
			$criteria =& new CriteriaCompo(new Criteria('hassearch', 1));
			$criteria->add(new Criteria('isactive', 1));
			$mids =& array_keys($moduleHandler->getList($criteria));
		}

		//
		// Next, fetch from $mids[], and check read permission.
		// If user can read the module information, execute search.
		//
		$root =& XCube_Root::getSingleton();
		$timezone = $root->mController->getConfig('server_TZ') * 3600;
		
		$i = 0;
		foreach ($mids as $mid) {
			if ($gpermHandler->checkRight('module_read', $mid, $groups)) {
				$module =& $moduleHandler->get($mid);
				if (!is_object($module)) {
					continue;
				}
				
				$results =& $module->search($queries, $andor, $max_hit, $start, $uid);
				
				$ret[$i]['mid'] = $mid;
				$ret[$i]['name'] = $module->get('name');
				
				if (is_array($results) && count($results) > 0) {
					foreach ($results as $result) {
						$item = array();
						if (isset($result['image']) && strlen($result['image']) > 0) {
							$item['image'] = XOOPS_URL . '/modules/' . $module->getVar('dirname') . '/' . $result['image'];
						}
						else {
							$item['image'] = XOOPS_URL . '/images/icons/posticon2.gif';
						}
						
						$item['link'] = XOOPS_URL . '/modules/' . $module->getVar('dirname') . '/' . $result['link'];
						$item['title'] = $result['title'];
						$item['uid'] = $result['uid'];
						
						//
						// TODO If this service will come to web service, we should
						// change format from unixtime to string by timeoffset.
						//
						$item['time'] = isset($result['time']) ? $result['time'] - $timezone : 0;
						
						$ret[$i]['results'][] = $item;
					}
					
					$ret[$i]['has_more'] = (count($results) == $max_hit);
				}
				else {
					$ret[$i]['results'] = array();
					$ret[$i]['showall_link'] = "";
				}
			}
		}
		
		return $ret;
	}

	function isOuterService()
	{
		return false;
	}
}

?>