<?php
/**
 * @package legacy
 * @version $Id: Legacy_EventFunctions.class.php,v 1.1.2.10 2006/08/04 04:36:39 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

class Legacy_EventFunction
{
	function imageManager()
	{
		require_once XOOPS_MODULE_PATH . "/base/class/ActionFrame.class.php";
		
		$root =& XCube_Root::getSingleton();
		$root->mController->mModuleController->setupModuleObject('base');
		$root->mController->mModuleController->setupRenderTarget();
	
		$moduleRunner =& new Legacy_ActionFrame(false);
		
		$action = isset($_REQUEST['op']) ? ucfirst(xoops_getrequest('op')) : "List";
		$moduleRunner->setMode(LEGACY_FRAME_MODE_IMAGE);
		$moduleRunner->setActionName($action);

		$root->mController->setActionStrategy($moduleRunner);

		$root->mController->executeAction();

		$root->mController->executeView();
	}

	function backend()
	{
		require_once XOOPS_MODULE_PATH . "/base/class/ActionFrame.class.php";
		
		$root =& XCube_Root::getSingleton();
		$root->mController->mModuleController->setupModuleObject('base');
		$root->mController->mModuleController->setupRenderTarget();
		
		$moduleRunner =& new Legacy_ActionFrame(false);
		$moduleRunner->setActionName('Backend');

		$root->mController->setActionStrategy($moduleRunner);

		$root->mController->executeAction();

		$root->mController->executeView();
	}

	function search()
	{
		require_once XOOPS_MODULE_PATH . "/base/class/ActionFrame.class.php";
		
		$root =& XCube_Root::getSingleton();
		$root->mController->mModuleController->setupModuleObject('base');
		$root->mController->mModuleController->setupRenderTarget();
		
		$moduleRunner =& new Legacy_ActionFrame(false);
		$moduleRunner->setMode(LEGACY_FRAME_MODE_SEARCH);
		$moduleRunner->setActionName(ucfirst(xoops_getrequest('action')));

		$root->mController->setActionStrategy($moduleRunner);

		$root->mController->executeAction();

		$root->mController->executeView();
		
	}
	
	function misc()
	{
		require_once XOOPS_BASE_PATH . "/class/ActionFrame.class.php";

		$root =& XCube_Root::getSingleton();
		$root->mController->mModuleController->setupModuleObject('base');
		$root->mController->mModuleController->setupRenderTarget();
		
		$actionName = isset($_REQUEST['type']) ? ucfirst(xoops_getrequest('type')) : "Smilies";

		$moduleRunner = new Legacy_ActionFrame(false);
		$moduleRunner->setMode(LEGACY_FRAME_MODE_MISC);
		$moduleRunner->setActionName($actionName);

		$root->mController->setActionStrategy($moduleRunner);

		$root->mController->setDialogMode(true);

		$root->mController->executeAction();

		$root->mController->executeView();
	}

	function notifications()
	{
		require_once XOOPS_BASE_PATH . "/class/ActionFrame.class.php";
		
		$root =& XCube_Root::getSingleton();
		$root->mController->mModuleController->setupModuleObject('base');
		$root->mController->mModuleController->setupRenderTarget();

		//
		// 'Notify' is prefix to guard accessing from misc.php.
		//
		$actionName = isset($_REQUEST['op']) ? trim(xoops_getrequest('op')) : "List";
		if (isset($_REQUEST['delete'])) {
			$actionName = "Delete";
		}
		if (isset($_REQUEST['delete_cancel'])) {
			$actionName = "Cancel";
		}

		$moduleRunner = new Legacy_ActionFrame(false);
		$moduleRunner->setMode(LEGACY_FRAME_MODE_NOTIFY);
		$moduleRunner->setActionName($actionName);

		$root->mController->setActionStrategy($moduleRunner);

		$root->mController->executeAction();

		$root->mController->executeView();
	}
	
	/**
	 * This functions is add to 'Legacyfunction.Notificatins.Select'.
	 * 
	 * @param XCube_RenderBuffer $render
	 */
	function notifications_select(&$render)
	{
		require_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
		require_once XOOPS_ROOT_PATH . '/include/notification_functions.php';

		$root =& XCube_Root::getSingleton();
		$xoopsModule =& $root->mController->mModuleController->mModuleObject;
		$moduleConfig =& $root->mController->mModuleController->mConfig;
		$xoopsUser =& $root->mController->getXoopsUser();

		$xoops_notification = array();
		$xoops_notification['show'] = is_object($xoopsModule) && is_object($xoopsUser) && notificationEnabled('inline') ? 1 : 0;
		
		if ($xoops_notification['show']) {
			$root->mLanguageManager->loadPageTypeMessageCatalog('notification');
			$categories =& notificationSubscribableCategoryInfo();
			$event_count = 0;
			if (!empty($categories)) {
				$notification_handler =& xoops_gethandler('notification');
				foreach ($categories as $category) {
					$section['name'] = $category['name'];
					$section['title'] = $category['title'];
					$section['description'] = $category['description'];
					$section['itemid'] = $category['item_id'];
					$section['events'] = array();
					$subscribed_events =& $notification_handler->getSubscribedEvents($category['name'], $category['item_id'], $xoopsModule->get('mid'), $xoopsUser->get('uid'));
					foreach (notificationEvents($category['name'], true) as $event) {
						if (!empty($event['admin_only']) && !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
							continue;
						}
						if (!empty($event['invisible'])) {
							continue;
						}
						$subscribed = in_array($event['name'], $subscribed_events) ? 1 : 0;
						$section['events'][$event['name']] = array ('name'=>$event['name'], 'title'=>$event['title'], 'caption'=>$event['caption'], 'description'=>$event['description'], 'subscribed'=>$subscribed);
						$event_count ++;
					}
					$xoops_notification['categories'][$category['name']] = $section;
				}
				$xoops_notification['target_page'] = "notification_update.php";
				$xoops_notification['redirect_script'] = xoops_getenv('PHP_SELF');
				
				$render->setAttribute('editprofile_url', $urlXOOPS_URL . '/edituser.php?uid=' . $xoopsUser->getShow('uid'));

				switch ($xoopsUser->getVar('notify_method')) {
				case XOOPS_NOTIFICATION_METHOD_DISABLE:
					$render->setAttribute('user_method', _NOT_DISABLE);
					break;
				case XOOPS_NOTIFICATION_METHOD_PM:
					$render->setAttribute('user_method', _NOT_PM);
					break;
				case XOOPS_NOTIFICATION_METHOD_EMAIL:
					$render->setAttribute('user_method', _NOT_EMAIL);
					break;
				}
			} else {
				$xoops_notification['show'] = 0;
			}
			if ($event_count == 0) {
				$xoops_notification['show'] = 0;
			}
		}
		
		$render->setAttribute('xoops_notification', $xoops_notification);
	}
	
	/**
	 * This member function is added to 'User_UserViewAction.GetUserPosts'.
	 * Recount posts of $xoopsUser in the comment system.
	 * 
	 * @static
	 */
	function recountPost(&$posts, $xoopsUser)
	{
		$handler =& xoops_gethandler('comment');
		$criteria =& new Criteria('com_uid', $xoopsUser->get('uid'));
		$posts += $handler->getCount($criteria);
	}
}

?>