<?php
/**
 * @package user
 * @version $Id: EditUserAction.class.php,v 1.1.2.10 2006/07/20 08:14:28 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/EditUserForm.class.php";

/**
 * @see User_EditUserForm
 */
class User_EditUserAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval(xoops_getrequest('uid')) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users');
		return $handler;
	}

	/**
	 * Because editable fields are decided by the module config, this member
	 * function hands the config to the constructor of the action form.
	 * 
	 * @see User_AbstractUserEditForm
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& new User_EditUserForm($this->mConfig);
		$this->mActionForm->prepare();
	}
	
	function isEnableCreate()
	{
		return false;
	}

	function isSecure()
	{
		return true;
	}
	
	/**
	 * Allow Conditions:
	 * 
	 * 1) The current user is the target user.
	 * 2) The current user is administrators.
	 */
	function hasPerm(&$controller, &$xoopsUser, $moduleConfig)
	{
		if ($this->mObject != null) {
			return ($this->mObject->get('uid') == $xoopsUser->get('uid') || $xoopsUser->isAdmin());
		}
		
		return false;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_edituser.html");
		$render->setAttribute("actionForm", $this->mActionForm);
		$render->setAttribute("thisUser", $this->mObject);
		$render->setAttribute("currentUser", $xoopsUser);
		$render->setAttribute("allow_chgmail", $this->mConfig['allow_chgmail']);
		
		$handler =& xoops_gethandler('timezone');
		$timezoneArr =& $handler->getObjects();
		$render->setAttribute('timezones', $timezoneArr);
		
		//
		// umode option
		//
		$umodeOptions = array("nest" => _NESTED, "flat" => _FLAT, "thread" => _THREADED);
		$render->setAttribute('umodeOptions', $umodeOptions);

		//		
		// uorder option
		//
		$uorderOptions = array(0 => _OLDESTFIRST, 1 => _NEWESTFIRST);
		$render->setAttribute('uorderOptions', $uorderOptions);

		//
		// notify option
		//

		//
		// TODO Because abstract message catalog style is not decided, we load directly.
		//
		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadPageTypeMessageCatalog('notification');
		require_once XOOPS_ROOT_PATH . "/include/notification_constants.php";

		$methodOptions = array(XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE,
		                         XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM,
		                         XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL
		                   );
		$render->setAttribute('notify_methodOptions', $methodOptions);
		
		$modeOptions = array(XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS,
		                       XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE,
		                       XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN
		                 );
		$render->setAttribute('notify_modeOptions', $modeOptions);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$render)
	{
		$controller->executeForward('./index.php?action=UserInfo&uid=' . $this->mObject->get('uid'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect(XOOPS_URL, 1, _MD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>