<?php
/**
 * @package user
 * @version $Id: GroupDeleteAction.class.php,v 1.1.2.3 2006/07/13 10:43:19 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/GroupAdminDeleteForm.class.php";

class User_GroupDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return xoops_getrequest('groupid');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('groups');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new User_GroupAdminDeleteForm();
		$this->mActionForm->prepare();
	}
	
	function _doExecute()
	{
		$handler =& xoops_gethandler('group');
		$group =& $handler->get($this->mObject->get('groupid'));
		
		$handler =& xoops_gethandler('member');
		return $handler->delete($group) ? USER_FRAME_VIEW_SUCCESS
		                                : USER_FRAME_VIEW_ERROR;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("group_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=GroupList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=GroupList", 1, _AD_USER_ERROR_DBUPDATE_FAILED);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=GroupList");
	}
}

?>
