<?php
/**
 * @package XCube
 * @version $Id: XCube_ActionFilter.class.php,v 1.1.2.2 2006/06/06 03:08:41 minahito Exp $
 */

/**
 * This class is chained and called by the initialization procedure of the
 * controller class. Developers or users can use the subclass of this class for
 * dynamic customizing.
 * 
 * Users usually don't need to add on filters because each controllers should
 * have initialization code enough. This class is used to the case of special
 * customizing by modules and users.
 * 
 * Each controllers should not use this class to their initialization procedure.
 * 
 * Two member functions are called by the controller at the special timing.
 * These timing is different in each controllers.
 */
class XCube_ActionFilter
{
	/**
	 * XCube_Controller
	 *
	 * @access protected
	 */
	var $mController;

	/**
	 * @param $controller XCube_Controller
	 */
	function XCube_ActionFilter(&$controller)
	{
		$this->mController =& $controller;
	}

	/**
	 * Execute the logic when preFilter().
	 * 
	 * @return void
	 */	
	function preFilter()
	{
	}
	
	/**
	 * Execute the logic when preBlockFilter().
	 * 
	 * @return void
	 */	
	function preBlockFilter()
	{
	}
}

?>
