<?php
/**
 * @package Legacy
 * @version $Id: BlockEditAction.class.php,v 1.1.2.9 2006/08/18 11:30:00 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/forms/BlockEditForm.class.php";

class Legacy_BlockEditAction extends Legacy_AbstractEditAction
{
	/**
	 * @var string
	 */
	var $_mOptionForm = null;
	
	function _getId()
	{
		return isset($_REQUEST['bid']) ? xoops_getrequest('bid') : 0;
	}
	
	function isEnableCreate()
	{
		return false;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('newblocks');
		return $handler;
	}

	function _setupObject()
	{
		parent::_setupObject();
		$this->mObject->loadGroup();
		$this->mObject->loadBmodule();
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_BlockEditForm();
		$this->mActionForm->prepare();
	}
	
	/**
	 * Return true if the target object can be edited. This private method exists 
	 * to control subclass actions.
	 * 
	 * @return bool
	 */
	function _isEditable()
	{
		if (is_object($this->mObject)) {
			return ($this->mObject->get('visible') == 1);
		}
		else {
			return false;
		}
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		if (!$this->_isEditable()) {
			return LEGACY_FRAME_VIEW_ERROR;
		}
		
		return parent::getDefaultView($controller, $xoopsUser);
	}

	function execute(&$controller, &$xoopsUser)
	{
		if (!$this->_isEditable()) {
			LEGACY_FRAME_VIEW_ERROR;
		}

		$ret = parent::execute($controller, $xoopsUser);
		
		if ($ret == LEGACY_FRAME_VIEW_SUCCESS) {
			//
			// Reset block_module_link.
			//
			$handler =& xoops_getmodulehandler('block_module_link', 'base');
			$handler->deleteAll(new Criteria('block_id', $this->mObject->get('bid')));
			foreach ($this->mObject->mBmodule as $bmodule) {
				//
				// If object is new, $bmodule isn't set bid yet.
				//
				$bmodule->set('block_id', $this->mObject->get('bid'));
				$handler->insert($bmodule);
			}

			//
			// Insert group permissions.
			//
			$currentGroupid = array();
			foreach ($this->mObject->mGroup as $group) {
				$currentGroupid[] = $group->get('groupid');
			}
			
			$permHandler =& xoops_gethandler('groupperm');
			$criteria =& new CriteriaCompo();
			$criteria->add(new Criteria('gperm_modid', 1));
			$criteria->add(new Criteria('gperm_itemid', $this->mObject->get('bid')));
			$criteria->add(new Criteria('gperm_name', 'block_read'));
			
			$gpermArr =&  $permHandler->getObjects($criteria);
			foreach ($gpermArr as $gperm) {
				if (!in_array($gperm->get('gperm_groupid', $currentGroupid))) {
					$permHandler->delete($gperm, $force);
				}
			}
			
			foreach ($this->mObject->mGroup as $group) {
				$insertFlag = true;
				foreach ($gpermArr as $gperm) {
					if ($gperm->get('gperm_groupid') == $group->get('group_id')) {
						$insertFlag = false;
					}
				}
				
				if ($insertFlag) {
					$gperm =& $permHandler->create();
					$gperm->set('gperm_modid', 1);
					$gperm->set('gperm_groupid', $group->get('groupid'));
					$gperm->set('gperm_itemid', $this->mObject->get('bid'));
					$gperm->set('gperm_name', 'block_read');
					
					$permHandler->insert($gperm, $force);
				}
			}
		}
		
		return $ret;
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("block_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		
		//
		// lazy loading
		//
		$this->mObject->loadModule();
		
		$render->setAttribute('object', $this->mObject);
		
		//
		// Build active modules list and set.
		//
		$handler =& xoops_gethandler('module');
		$moduleArr[0] =& $handler->create();
		$moduleArr[0]->set('mid', -1);
		$moduleArr[0]->set('name', _AD_BASE_LANG_TOPPAGE);
		
		$moduleArr[1] =& $handler->create();
		$moduleArr[1]->set('mid', 0);
		$moduleArr[1]->set('name', _AD_BASE_LANG_ALL_MODULES);

		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('hasmain', 1));
		$criteria->add(new Criteria('isactive', 1));
		
		$t_Arr =& $handler->getObjects($criteria);
		$moduleArr = array_merge($moduleArr, $t_Arr);
		$render->setAttribute('moduleArr', $moduleArr);
		
		$handler =& xoops_getmodulehandler('columnside');
		$columnSideArr =& $handler->getObjects();
		$render->setAttribute('columnSideArr', $columnSideArr);

		$handler =& xoops_gethandler('group');
		$groupArr =& $handler->getObjects();
		$render->setAttribute('groupArr', $groupArr);
		
		//
		// Build cachetime list and set.
		//
		$handler =& xoops_gethandler('cachetime');
		$cachetimeArr =& $handler->getObjects();
		$render->setAttribute('cachetimeArr', $cachetimeArr);

		//
		// Get html of option form rendered.
		//
		if ($this->mObject->get('func_file') && $this->mObject->get('edit_func')) {
			$func_file = XOOPS_MODULE_PATH . "/" . $this->mObject->get('dirname') . "/blocks/" . $this->mObject->get('func_file');
			if (file_exists($func_file)) {
				require $func_file;
				$edit_func = $this->mObject->get('edit_func');
				
				$options = explode('|', $this->mObject->get('options'));
				
				if (function_exists($edit_func)) {
					//
					// load language file.
					//
					$root =& XCube_Root::getSingleton();
					$langManager =& $root->getLanguageManager();
					$langManager->loadBlockLanguage($this->mObject->get('dirname'));
					
					$this->_mOptionForm = call_user_func($edit_func, $options);
				}
			}
		}
		$render->setAttribute('optionForm', $this->_mOptionForm);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=BlockList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=BlockList", 1, _MD_BASE_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=BlockList");
	}
}

?>
