<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";

/**
 * This class is generated by makeActionForm tool.
 */
class User_AbstractUserEditForm extends XCube_ActionForm
{
	var $mConfig = null;
	
	function User_AbstractUserEditForm($userConfig)
	{
		parent::XCube_ActionForm();
		$this->mConfig = $userConfig;
	}
	
	function validateUname()
	{
		if($this->get('uname')) {
			//
			// uname unique check
			//
			$userHandler=&xoops_gethandler('user');
			$criteria =& new CriteriaCompo(new Criteria('uname', $this->get('uname')));
			if ($this->get('uid')) {
				$criteria->add(new Criteria('uid', $this->get('uid'), '<>'));
			}
			if ($userHandler->getCount($criteria) > 0) {
				$this->addErrorMessage(_MD_USER_LANG_NICKNAMETAKEN);
			}

			//
			// Check allow uname string pattern.
			//
			$regex="";
			switch($this->mConfig['uname_test_level']) {
				case 0:
					$regex="/[^a-zA-Z0-9\_\-]/";
					break;

				case 1:
					$regex="/[^a-zA-Z0-9\_\-\<\>\,\.\$\%\#\@\!\\\'\"]/";
					break;

				case 2:
					$regex="//[\000-\040]/";
					break;
			}
			if(preg_match($regex,$this->get('uname'))) {
				$this->addErrorMessage(_MD_USER_LANG_INVALIDNICKNAME);
			}

			//
			// Check bad uname patterns.
			//
			foreach(explode("|",$this->mConfig['bad_unames']) as $pattern) {
				if(!empty($pattern)&&preg_match("/".$pattern."/i",$this->get('uname'))) {
					$this->addErrorMessage(_MD_USER_LANG_NAMERESERVED);
					break;
				}
			}
		}
	}

	function validateTimezone_offset()
	{
		$handler =& xoops_gethandler('timezone');
		$obj =& $handler->get($this->get('timezone_offset'));
		if (!is_object($obj)) {
			$this->addErrorMessage(_MD_USER_ERROR_TIMEZONE);
		}
	}
	
	function validateUrl()
	{
		$t_url = $this->get('url');
		if (strlen($t_url) > 0) {
			if (!preg_match('/^https?(:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)$/', $t_url)) {
				$this->addErrorMessage(XCube_Utils::formatMessage(_MD_USER_ERROR_INJURY, _MD_USER_LANG_URL));
			}
		}
	}
	
	/**
	 * @todo 'HANKAKU' check.
	 */
	function validatePass()
	{
		if (strlen($this->get('pass'))>0||strlen($this->get('vpass'))>0) {
			if($this->get('pass')!=$this->get('vpass')) {
				$this->addErrorMessage(_MD_USER_ERROR_PASSWORD);
				$this->set('pass',null);	// reset
				$this->set('vpass',null);
			}
		}
	}
}

?>
