<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     modifier
 * Name:     xoops_date_format
 * Purpose:  format datestamps via strftime ( use xoops timestamp )
 * Input:    time: input date unixtime
 *           format: strftime format for output
 * -------------------------------------------------------------
 */
function smarty_modifier_xoops_date_format($time, $format="%b %e, %Y")
{
	if($time && is_numeric($time)) {
		return strftime ( $format, xoops_getUserTimestamp ( $time ) );
	}
	return;
}

?>
