<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionStrategy.class.php";

define ("LEGACY_FRAME_PERFORM_SUCCESS", 1);
define ("LEGACY_FRAME_PERFORM_FAIL", 2);
define ("LEGACY_FRAME_INIT_SUCCESS", 3);

define ("LEGACY_FRAME_VIEW_NONE", 1);
define ("LEGACY_FRAME_VIEW_SUCCESS", 2);
define ("LEGACY_FRAME_VIEW_ERROR", 3);
define ("LEGACY_FRAME_VIEW_INDEX", 4);
define ("LEGACY_FRAME_VIEW_INPUT", 5);
define ("LEGACY_FRAME_VIEW_PREVIEW", 6);
define ("LEGACY_FRAME_VIEW_CANCEL", 7);

//
// Constatns for the mode of the frame.
//
define ("LEGACY_FRAME_MODE_MISC", "Misc");
define ("LEGACY_FRAME_MODE_NOTIFY", "Notify");
define ("LEGACY_FRAME_MODE_IMAGE", "Image");
define ("LEGACY_FRAME_MODE_SEARCH", "Search");

class Legacy_ActionFrame extends XCube_ActionStrategy
{
	var $mActionName = null;
	var $mAction = null;
	var $mAdminFlag = null;

	/**
	 * Mode. The rule refers this property to load a file and create an
	 * instance in execute().
	 * 
	 * @var string
	 */	
	var $mMode = null;

	function Legacy_ActionFrame($admin)
	{
		$this->mAdminFlag = $admin;
	}

	function setActionName($name)
	{
		$this->mActionName = $name;
	}
	
	/**
	 * Set mode.
	 * 
	 * @param string $mode   Use constants (LEGACY_FRAME_MODE_MISC and more...)
	 */
	function setMode($mode)
	{
		$this->mMode = $mode;
	}

	function execute(&$controller)
	{
		if (strlen($this->mActionName) > 0 && !preg_match("/^\w+$/", $this->mActionName)) {
			die();
		}

		//
		// Actions of the public side in this module are hook type. So it's
		// necessary to load catalog here.
		//		
		if (!$this->mAdminFlag) {
			$controller->mRoot->mLanguageManager->loadModuleMessageCatalog('base');
		}
		
		//
		// Add mode.
		//
		$this->mActionName = $this->mMode . $this->mActionName;
	
		//
		// Create action object by mActionName
		//
		$className = "Legacy_" . ucfirst($this->mActionName) . "Action";
		$fileName = ucfirst($this->mActionName) . "Action";
		if ($this->mAdminFlag) {
			$fileName = XOOPS_MODULE_PATH . "/base/admin/actions/${fileName}.class.php";
		}
		else {
			$fileName = XOOPS_MODULE_PATH . "/base/actions/${fileName}.class.php";
		}
	
		if (!file_exists($fileName)) {
			die();
		}
	
		require_once $fileName;
	
		if (class_exists($className)) {
			$this->mAction =& new $className($this->mAdminFlag);
		}
	
		if (!is_object($this->mAction)) {
			die();
		}
		
		$this->mAction->prepare($controller, $controller->getXoopsUser());
	
		if (!$this->mAction->hasPerm($controller, $controller->getXoopsUser())) {
			if ($this->mAdminFlag) {
				$controller->executeForward(XOOPS_URL . "/admin.php");
			}
			else {
				$controller->executeForward(XOOPS_URL);
			}
		}
	
		if (xoops_getenv("REQUEST_METHOD") == "POST") {
			$viewStatus = $this->mAction->execute($controller, $controller->getXoopsUser());
		}
		else {
			$viewStatus = $this->mAction->getDefaultView($controller, $controller->getXoopsUser());
		}
	
		switch($viewStatus) {
			case LEGACY_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACY_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACY_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACY_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;

			case LEGACY_FRAME_VIEW_PREVIEW:
				$this->mAction->executeViewPreview($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;

			case LEGACY_FRAME_VIEW_CANCEL:
				$this->mAction->executeViewCancel($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		}
	}
}

class Legacy_Action
{
	/**
	 * @access private
	 */
	var $_mAdminFlag = false;
	
	function Legacy_Action($adminFlag = false)
	{
		$this->_mAdminFlag = $adminFlag;
	}

	function hasPerm(&$controller, &$xoopsUser)
	{
		if ($this->_mAdminFlag) {
			$moduleHandler =& xoops_gethandler('module');
			$permHandler =& xoops_gethandler('groupperm');
		
			$module =& $moduleHandler->getByDirname('base');
		
			return $permHandler->checkRight('module_admin', $module->get('mid'), $xoopsUser->getGroups());
		}
		else {
			//
			// TODO Really?
			//
			return true;
		}
	}
	
	function prepare(&$controller, &$xoopsUser)
	{
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return LEGACY_FRAME_VIEW_NONE;
	}

	function execute(&$controller, &$xoopsUser)
	{
		return LEGACY_FRAME_VIEW_NONE;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewPreview(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
	}
}

?>
