<?php
// $Id: StdRenderCache.class.php,v 1.1.2.3 2006/05/28 09:01:03 nobunobu Exp $

require_once XOOPS_ROOT_PATH . "/kernel/XCube_RenderCache.class.php";

/**
 * This is standard render cache class. It makes cash by a group of a user.
 * Therefore cash does not collide, but a cache file is made a lot.
 *
 * The processing should be limited so that this class gives standard.
 * For example, this makes cash only for a guest with registered user.
 */
class StdRenderCache extends XCube_RenderCache
{
	var $mGroupIds = array();
	
	function StdRenderCache()
	{
		parent::XCube_RenderCache();
		
		$root =& XCube_Root::getSingleton();

		$user =& $root->mController->mXoopsUser;

		$groups = is_object($user) ? $user->getGroups() : XOOPS_GROUP_ANONYMOUS;
		$this->_setGroupIds($groups);
	}

	/**
	 * @return bool
	 */
	function isCache($cachetime = null)
	{
		if ($cachetime === 0) {
			return false;
		}
		
		if (!$this->enableCache()) {
			return false;
		}
		
		$filename = XOOPS_CACHE_PATH . "/" . $this->getCacheId() . ".cache.html";
		if (!file_exists($filename)) {
			return false;
		}
		
		if($cachetime === null) {
			return true;
		}

		//
		// Check expire
		//
		$time = time() - filemtime($filename);
		if ($time > $cachetime) {
			return false;
		}

		return true;
	}

	function enableCache()
	{
		return (count($this->mGroupIds) == 1 && ($this->mGroupIds[0] == XOOPS_GROUP_USERS || $this->mGroupIds[0] == XOOPS_GROUP_ANONYMOUS));
	}
	
	function _setGroupIds($ids)
	{
		if (is_array($ids)) {
			sort($ids);
			$this->mGroupIds = $ids;
		}
		else {
			$this->mGroupIds = array();
			$this->mGroupIds[] = $ids;
		}
	}

	function getCacheId()
	{
		return md5($this->mResourceName . implode("_", $this->mGroupIds));
	}

	function _getFileName()
	{
		return XOOPS_CACHE_PATH . "/" . $this->getCacheId() . ".cache.html";
	}
}

?>