<?php
/**
 * @package legacy
 * @version $Id: Legacy_ModuleController.class.php,v 1.1.2.13 2006/09/25 09:37:07 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/modules/base/kernel/Legacy_CacheInformation.class.php";

define("LEGACY_XOOPS_MODULE_MANIFESTO_FILENAME", "./xoops_version.php");

/**
 * This class is the part of Legacy_Controller. Because that controller class
 * is too large, this class has been separated. And, this class is the strategy
 * at Legacy_Controller.
 */
class Legacy_ModuleController
{
	/**
	 * @var Legacy_Controller
	 */
	var $mController;
	
	var $mModuleObject;
	
	var $mConfig = array();
	
	/**
	 * The render buffer for this module.
	 *
	 * @var XCube_RenderTarget
	 */
	var $mRenderTarget = null;
	
	/**
	 * The cache information for the current module.
	 * @var Legacy_CacheInformation
	 */
	var $mCacheInfo = null;
	
	function Legacy_ModuleController(&$controller)
	{
		$this->mController =& $controller;
		$this->mCacheInformation =& new Legacy_ModuleCacheInformation();
	}

	function getConfig($key = null)
	{
		if($key != null) {
			return isset($this->mConfig[$key]) ? $this->mConfig[$key] : null;
		}
		else {
			return $this->mConfig;
		}
	}

	function _isActiveCheck()
	{
		return true;
	}

	function prepare()
	{
		// Is this request module process?
		if (!$this->isModuleProcess()) {
			return;
		}

		//
		// Set up module object
		//
		$this->setupModuleObject($this->_getDirName());
			
		if ($this->_isActiveCheck() && !$this->isActive()) {
			return;
		}

		//
		// Setup render buffer.
		//
		$this->setupRenderTarget();
	}

	/**
	 * Create an object of the specified module, and set it to member property
	 * $mModuleObject. And load the config of the module, too.
	 * 
	 * This member function is useful in the case that active module and
	 * current module are different.
	 * 
	 * @param string $dirname
	 * @see prepare()
	 * @see setupRenderTarget()
	 */	
	function setupModuleObject($dirname)
	{
		$handler =& xoops_gethandler('module');
		$this->mModuleObject =& $handler->getByDirname($dirname);
		
		if ($this->mModuleObject != null) {
			if ($this->mModuleObject->get('hasconfig') == 1 || $this->mModuleObject->get('hascomments') == 1) {
				$configHandler =& xoops_gethandler('config');
				$this->mConfig =& $configHandler->getConfigsByCat(0, $this->mModuleObject->get('mid'));
			}
		}
	}
	
	/**
	 * Create an object of the render-target, and set it to member property
	 * $mRenderTarget. If $dirname is empty, fetch dirname from current module
	 * object and use it.
	 * 
	 * This member function is useful to regenerate the render-target. For
	 * example, if active module and current module are different, the active
	 * module needs regenerating the render-target.
	 * 
	 * @param string $dirname
	 * @see prepare()
	 */	
	function setupRenderTarget($dirname = null)
	{
		$renderSystem =& $this->mController->mRoot->getRenderSystem($this->getRenderSystemName());
		$this->mRenderTarget =& $renderSystem->createRenderTarget(XCUBE_RENDER_TARGET_TYPE_MAIN);
		if ($dirname == null) {
			if (is_object($this->mModuleObject)) {
				$this->mRenderTarget->setModuleName($this->mModuleObject->get('dirname'));
			}
		}
		else {
			$this->mRenderTarget->setModuleName($dirname);
		}
	}

	/**
	 * If this request is calling module, return true.
	 * @return boolean
	 */
	function isModuleProcess()
	{
		return file_exists(LEGACY_XOOPS_MODULE_MANIFESTO_FILENAME);
	}
	
	/**
	 * If module requested is available, return true.
	 * @return boolean
	 */
	function isActive()
	{
		return is_object($this->mModuleObject) && $this->mModuleObject->getVar('isactive');
	}
	
	/**
	 * If the current user can access to this module, return true.
	 * 
	 * @todo This method re-writes $GLOBAL['xoopsUserIsAdmin']! Wmm...
	 * @return bool
	 */
	function hasPermission()
	{
		$xoopsUser =& $this->mController->mXoopsUser;
		$xoopsModule=&$this->mModuleObject;
        $modPermHandler =& xoops_gethandler('groupperm');

		if(is_object($xoopsUser)) {
			if (!$modPermHandler->checkRight('module_read', $xoopsModule->getVar('mid'), $xoopsUser->getGroups())) {
				return false;
			}
			$GLOBALS['xoopsUserIsAdmin']=$xoopsUser->isAdmin($xoopsModule->getVar('mid'));
			return true;
		}
		else {
			$GLOBALS['xoopsUserIsAdmin'] = false;
			return $modPermHandler->checkRight('module_read', $xoopsModule->getVar('mid'), XOOPS_GROUP_ANONYMOUS);
		}
	}

	/**
	 @return void
	*/
	function _createModuleObject()
	{
		$moduleHandler=&xoops_gethandler('module');
		$this->mModuleObject =& $moduleHandler->getByDirname($this->_getDirname());
	}


	function _getDirname()
	{
	    $url_arr = explode("/",strstr($_SERVER['REQUEST_URI'],'/modules/'));
	    return (isset($url_arr[2])) ? $url_arr[2] : null;
	}
	
	function setupLanguage($dirname = null)
	{
		$languageManager =& $this->mController->mRoot->getLanguageManager();
		if ($dirname == null) {
			$languageManager->loadModuleMessageCatalog($this->mModuleObject->getVar('dirname'));
		}
		else {
			$languageManager->loadModuleMessageCatalog($dirname);
		}
	}
	
	function _processErrorModuleNotExist()
	{
		// Wmm...
		require_once XOOPS_ROOT_PATH ."/header.php";
		print "<h4>" . _MODULENOEXIST . "</h4>";
		require_once XOOPS_ROOT_PATH ."/footer.php";
		exit();
	}

	function getModuleDir()
	{
		return XOOPS_ROOT_PATH."/modules/".$this->mModuleObject->getVar('dirname');
	}

	/**
	 *  Return module's directory name. This function is dependent on the design
	 * of Legacy.
	 */	
	function getDirname()
	{
		return is_object($this->mModuleObject) ? $this->mModuleObject->get('dirname') : null;
	}
	
	function &getXoopsModule()
	{
		return $this->mModuleObject;
	}
	
	function &getRenderTarget()
	{
		return $this->mRenderTarget;
	}
	
	function getRenderSystemName()
	{
		return $this->getDependRenderSystem();
	}
	
	/**
	 * @deprecated
	 */
	function getDependRenderSystem()
	{
		return "Legacy_RenderSystem";
	}
	
	/**
	 * Initializes a cache information object, and returns it.
	 * @return Legacy_ModuleCacheInformation
	 */
	function &createCacheInfo()
	{
		$this->mCacheInfo =& new Legacy_ModuleCacheInformation();
		$this->mCacheInfo->mURL = xoops_getenv('REQUEST_URI');
		$this->mCacheInfo->setModule($xoopsModule);
		
		return $this->mCacheInfo;
	}

	/**
	 * Gets a value indicating whether the current module has a option of
	 * configurations to use the cache system.
	 * @return bool
	 */
	function hasCacheConfig()
	{
		if (xoops_getenv('REQUEST_METHOD') == 'POST') {
			return false;
		}
		
		return is_object($this->mModuleObject) && !empty($this->mController->mConfig['module_cache'][$this->mModuleObject->get('mid')]);
	}
}
?>