<?php
/**
 * @package ShadePlus
 * @varsion $Id: ServiceServer.class.php,v 1.1.2.1 2006/10/14 14:55:28 minahito Exp $
 * 
 * In the original BSD license, both occurrences of the phrase "COPYRIGHT
 * HOLDERS AND CONTRIBUTORS" in the disclaimer read "REGENTS AND CONTRIBUTORS".
 * 
 * Copyright (c) 2006, XOOPS Cube Project team/minahito (minahito@users.sourceforge.jp)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * a) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * b) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * c) Neither the name of the XOOPS Cube Project team nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

class ShadePlus_ServiceServer
{
	var $_mService;
	
	var $_mServer;
	
	function ShadePlus_ServiceServer(&$service)
	{
		$this->_mService =& $service;
		$this->_mServer =& new ShadeSoap_NusoapServer();
		
		$this->_mServer->configureWSDL($this->_mService->mServiceName, $this->_mService->mNameSpace);
		$this->_mServer->wsdl->schemaTargetNamespace = $this->_mService->mNameSpace;
	}
	
	function prepare()
	{
		$this->_parseType();
		$this->_parseFunction();
	}
	
	function _parseType()
	{
		//
		// FIXME
		//
		foreach ($this->_mService->_mTypes as $className) {
			if (class_exists($className)) {
				if (call_user_func(array($className, 'isArray')) == true) {
					$targetClassName = call_user_func(array($className, 'getClassName'));
					
					if (XCube_ServiceUtils::isXSD($targetClassName)) {
						$targetClassName = 'xsd:' . $targetClassName;
					}
					else {
						$targetClassName = 'tns:' . $targetClassName;
					}
					
					$this->_mServer->wsdl->addComplexType(
						$className,
						'complexType',
						'array',
						'',
						'SOAP-ENC:Array',
						array(),
						array(
							array('ref' => 'SOAP-ENC:arrayType', 'wsdl:arrayType' => $targetClassName . '[]')
						),
						$targetClassName
					);
				}
				else {
					$t_fieldArr = call_user_func(array($className, 'getPropertyDefinition'));
					$t_arr = array();
					foreach ($t_fieldArr as $t_field) {
						$name = $t_field['name'];
						$type = $t_field['type'];
					
						if (XCube_ServiceUtils::isXSD($t_field['type'])) {
							$type = 'xsd:' . $type;
						}
						else {
							$type = 'tns:' . $type;
						}
					
						$t_arr[$name] = array('name' => $name, 'type' => $type);
					}
				
					$this->_mServer->wsdl->addComplexType(
						$className,
						'complexType',
						'struct',
						'all',
						'',
						$t_arr
					);
				}
			}
		}
	}
	
	function _parseFunction()
	{
		//
		// FIXME
		//
		foreach ($this->_mService->_mFunctions as $func) {
			if (XCube_ServiceUtils::isXSD($func['out'])) {
				$t_out = 'xsd:' . $func['out'];
			}
			else {
				$t_out = 'tns:' . $func['out'];
			}
			
			$out['return'] = $t_out;
			
			//
			// Parse IN
			//
			$in = array();
			foreach ($func['in'] as $name => $type) {
				if (XCube_ServiceUtils::isXSD($type)) {
					$t_type = 'xsd:' . $type;
				}
				else {
					$t_type = 'tns:' . $type;
				}
				$in[$name] = $t_type;
			}
			
			$this->_mServer->register($this->_mService->mClassName . "." . $func['name'], $in, $out, $this->_mService->mNameSpace);
		}
	}
	
	function executeService()
	{
		$HTTP_RAW_POST_DATA = isset($GLOBALS['HTTP_RAW_POST_DATA'])? $GLOBALS['HTTP_RAW_POST_DATA'] : null;
		$this->_mServer->service($HTTP_RAW_POST_DATA);
	}
}

?>