<?php
// $Id: weblinks_atomfeed.php,v 1.1.1.1 2005/02/16 17:32:30 ohwada Exp $

// 2005-01-20 K.OHWADA
// add _MB_WEBLINKS_MORE
// add $future

//=========================================================
// block atomfeed
// created since v0.9
// 2004-11-28 K.OHWADA
//=========================================================

//---------------------------------------------------------
// $options
// [0] the display number of atomfeed (10)
// [1] max of title length (25)
// [2] max of summary      (100)
//---------------------------------------------------------

// --- change function name ---
function b_weblinks_atom_show($options) 
{
	global $xoopsDB;

// --- change dir name ---
	$MODULE_DIRNAME = 'weblinks';

	$MODULE_URL     = XOOPS_URL."/modules/".$MODULE_DIRNAME;
	$table_atomfeed = $xoopsDB->prefix( $MODULE_DIRNAME."_atomfeed" );

	$myts =& MyTextSanitizer::getInstance();

	$block = array();

	$block["lang_more"]  = _MB_WEBLINKS_MORE;
	$block["module_url"] = $MODULE_URL;

	$limit       = $options[0];
	$max_title   = $options[1] - 1 ;
	$max_summary = $options[2] - 1 ;

	$DAY    = 3;
	$future = time() + $DAY*24*3600;

	$sql    = "SELECT * FROM $table_atomfeed WHERE time_modified < $future ORDER BY time_modified DESC";
	$result = $xoopsDB->query($sql, $limit, 0);

	while( $row = $xoopsDB->fetchArray($result) )
	{
		$site_title = $row['site_title'];
		$site_url   = $row['site_url'];
		$title      = $row['title'];
		$url        = $row['url'];
		$content    = $row['content'];
		$time_modified = $row['time_modified'];
	
		$feed = array();

// site_title
		if (strlen( $site_title ) > $max_title) 
		{
			$site_title = strip_tags( $site_title );

// for multibyte environment
			if (function_exists('mb_strimwidth'))
			{
				$site_title = mb_strimwidth( $site_title, 0, $max_title, " ..." );
			}
			else
			{
				$site_title = substr( $site_title, 0, $max_title )." ...";
			}
		}
		elseif ( empty($site_title) )
		{
			$site_title = "---";
		}

// title
		if (strlen( $title ) > $max_title) 
		{
			$title = strip_tags( $title );

// for multibyte environment
			if (function_exists('mb_strimwidth'))
			{
				$title = mb_strimwidth( $title, 0, $max_title, " ..." );
			}
			else
			{
				$title = substr( $title, 0, $max_title )." ...";
			}
		}
		elseif ( empty($title) )
		{
			$title = "---";
		}

// summary
		$summary = $content;
		$summary = preg_replace("|<BR>|i",   ' ', $summary);
		$summary = preg_replace("|<BR />|i", ' ', $summary);
		$summary = strip_tags( $content );

		if ($max_summary == 0)
		{
			$summary = '';
		}
		elseif (strlen( $summary ) > $max_summary) 
		{

// for multibyte environment
			if (function_exists('mb_strimwidth'))
			{
				$summary = mb_strimwidth( $summary, 0, $max_summary, " ..." );
			}
			else
			{
				$summary = substr( $summary, 0, $max_summary )." ...";
			}
		}

// date
		$date = '';

		if ( $time_modified ) 
		{
			$date = formatTimestamp($time_modified, "s");
		}

		$feed['date']       = $date;
		$feed['site_url']   = htmlspecialchars($site_url, ENT_QUOTES);
		$feed['url']        = htmlspecialchars($url,      ENT_QUOTES);
		$feed['site_title'] = $myts->makeTboxData4Show( $site_title );
		$feed['title']      = $myts->makeTboxData4Show( $title );
		$feed['summary']    = $myts->makeTboxData4Show( $summary );

		$block['feeds'][] = $feed;
	}

	return $block;
}

// --- change function name ---
function b_weblinks_atom_edit($options) 
{
	$form  = ""._MB_WEBLINKS_NUM_FEED."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[0]."' />&nbsp;"._MB_WEBLINKS_LINKS."<br />";

	$form .= ""._MB_WEBLINKS_NUM_TITLE."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[1]."' />&nbsp;"._MB_WEBLINKS_LENGTH."<br />";

	$form .= ""._MB_WEBLINKS_NUM_SUMMARY."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[2]."' />&nbsp;"._MB_WEBLINKS_LENGTH."";

	return $form;
}


//---------------------------------------------------------
// $options
// [0] link id (0)
// [1] the display number of atomfeed (10)
// [2] the display number of content  (1)
// [3] max of summary  (200)
//---------------------------------------------------------

// --- change function name ---
function b_weblinks_blog_show($options) 
{
	global $xoopsDB;

// --- change dir name ---
	$MODULE_DIRNAME = 'weblinks';

	$MODULE_URL     = XOOPS_URL."/modules/".$MODULE_DIRNAME;
	$table_atomfeed = $xoopsDB->prefix( $MODULE_DIRNAME."_atomfeed" );

	$myts =& MyTextSanitizer::getInstance();

	$block = array();

	$lid         = $options[0];
	$limit       = $options[1];
	$num_content = $options[2];
	$max_summary = $options[3] - 1 ;

// no link id
	if ($lid == 0)
	{
		$block['feed_show']  = 0;
		$block['lang_error'] = _MB_WEBLINKS_NO_LINK_ID;
		return $block;
	}

	$sql    = "SELECT * FROM $table_atomfeed WHERE lid=$lid ORDER BY time_modified DESC";
	$result = $xoopsDB->query($sql, $limit, 0);

	$num = mysql_num_rows($result);

// no atomfeed
	if ( $num == 0 )
	{
		$block['feed_show']  = 0;
		$block['lang_error'] = _MB_WEBLINKS_NO_ATOMFEED;
		return $block;
	}

	$i = 0;
	while( $row = $xoopsDB->fetchArray($result) )
	{
		$site_title = $row['site_title'];
		$site_url   = $row['site_url'];
		$title      = $row['title'];
		$url        = $row['url'];
		$content    = $row['content'];
		$time_modified = $row['time_modified'];

		$feed = array();

// title
		if ( empty($title) )
		{
			$title = "---";
		}

// summary
		$summary = $content;
		$summary = str_replace(">", "> ", $summary);
		$summary = strip_tags( $summary );

		if ($max_summary == 0)
		{
			$summary = '';
		}
		elseif (strlen( $summary ) > $max_summary) 
		{

// for multibyte environment
			if (function_exists('mb_strimwidth'))
			{
				$summary = mb_strimwidth( $summary, 0, $max_summary, " ..." );
			}
			else
			{
				$summary = substr( $summary, 0, $max_summary )." ...";
			}
		}

// date
		$date = '';

		if ( $time_modified ) 
		{
			$date = formatTimestamp($time_modified, "m");
		}

		$feed['content'] = $content;
		$feed['date']    = $date;
		$feed['url']     = htmlspecialchars($url, ENT_QUOTES);
		$feed['title']   = $myts->makeTboxData4Show( $title );
		$feed['summary'] = $myts->makeTboxData4Show( $summary );

		$i ++;
		$block['feeds'][] = $feed;
	}

	if ( empty($site_title) )
	{
		$site_title = "---";
	}

	$block['feed_show']   = 1;
	$block['num_content'] = $num_content;
	$block['site_url']    = htmlspecialchars($site_url, ENT_QUOTES);
	$block['site_title']  = $myts->makeTboxData4Show( $site_title );

	return $block;
}


// --- change function name ---
function b_weblinks_blog_edit($options) 
{
	$form  = ""._MB_WEBLINKS_LINK_ID."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[0]."' />&nbsp; <br />";

	$form .= ""._MB_WEBLINKS_NUM_FEED."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[1]."' />&nbsp;"._MB_WEBLINKS_LINKS."<br />";

	$form .= ""._MB_WEBLINKS_NUM_CONTENT."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[2]."' />&nbsp;"._MB_WEBLINKS_LINKS."<br />";

	$form .= ""._MB_WEBLINKS_NUM_SUMMARY."&nbsp;";
	$form .= "<input type='text' name='options[]' value='".$options[3]."' />&nbsp;"._MB_WEBLINKS_LENGTH."";

	return $form;
}

?>
