<?php
// $Id: weblinks_catlist.php,v 1.2 2005/03/12 14:31:39 ohwada Exp $

// 2005-03-12 K.OHWADA
// bug fix: show all sub categories when $options[0] = 0

// 2005-01-20 K.OHWADA
// allow_url_fopen 
// add $optons 3:default width
// add orders

// 2004-12-05 K.OHWADA
// write fair, delete unnecessary comments

// 2004-10-20 K.OHWADA
// some changes by ken
// some idea by tom

// ========================================================
// FILE		::	weblinks_catlist.php
// AUTHOR	::	Ryuji AMANO <info@ryus.biz>
// WEB		::	Ryu's Planning <http://ryus.biz/>
// ========================================================

//---------------------------------------------------------
// $options
// [0] the display number of subcategory (5)
// [1] category image mode (1)
//       0: none
//       1: folder.gif
//       2: category image
// [2] max width of catergory image (100)
//       when 0, not show
// [3] default width of catergory image (50)
//       when 0, use original size
//---------------------------------------------------------

// --- change function name ---
function b_weblinks_catlist_show($options) 
{
	global $xoopsDB;

	require_once(XOOPS_ROOT_PATH."/class/xoopstree.php");

// --- change function name ---    
	$MODULE_DIRNAME = 'weblinks';
	$MODULE_URL     = XOOPS_URL."/modules/".$MODULE_DIRNAME;

	$num_show      = $options[0];
	$image_mode    = $options[1];
	$max_width     = $options[2];
	$width_default = $options[3];

	$table_category = $xoopsDB->prefix($MODULE_DIRNAME."_category");
	$table_catlink  = $xoopsDB->prefix($MODULE_DIRNAME."_catlink");
	$table_link     = $xoopsDB->prefix($MODULE_DIRNAME."_link");

    $myts =& MyTextSanitizer::getInstance(); // MyTextSanitizer object
    $mytree = new XoopsTree($table_category,"cid","pid");

    $count = 1;
    $retVars = array();

	$MAX_BROKEN = 5;

	$sql = "SELECT count(*) FROM ".$table_link." WHERE broken < $MAX_BROKEN";
	$array = $xoopsDB->fetchRow( $xoopsDB->query( $sql ) );
	$num   = $array[0];
	if (empty($num)) $num = 0;
	$retVars["total_links"] = $num;

	$retVars["lang_total_links"] = _MB_WEBLINKS_TOTAL_LINKS;
	$retVars["lang_links"]       = _MB_WEBLINKS_LINKS;

// top catergory
	$sql = "SELECT * FROM ".$table_category." WHERE pid=0 ORDER BY orders, cid";
	$result = $xoopsDB->query($sql);
	while($record = $xoopsDB->fetchArray($result))
	{
		$cid    = $record['cid'];
		$title  = $record['title'];
		$imgurl = $record['imgurl'];

// image
		$imgurl_myts = '';
		$width       = 0;
		$height      = 0;
		if (($image_mode == 2) && ($max_width > 0) && $imgurl && ($imgurl != "http://"))
		{
			$imgurl_myts = htmlspecialchars($imgurl, ENT_QUOTES);

			if ( get_cfg_var('allow_url_fopen') )
			{
				$size = GetImageSize( $imgurl );
				if ($size)
				{
					$width = intval( $size[0] );

					if ($width > $max_width)
					{
						$width = $max_width;
					}
				}
			}

			if (($width == 0) && ($width_default > 0))
			{
				$width = $width_default;
			}
		}

// number of links by category
		$sql = "SELECT count(DISTINCT lid) FROM ".$table_catlink." WHERE cid=".$cid;
		$child_array = $mytree->getAllChildId($cid);

		if ( count($child_array) > 0 )
		{
			$sql .= " OR cid=";
			$sql .= implode(" OR cid=", $child_array);
		}

		$countResult = $xoopsDB->query($sql);
		list($totallink) = $xoopsDB->fetchRow($countResult);

// sub category list
		$subcategories="";

// bug fix: show all sub categories when $options[0] = 0
		if ( $num_show > 0 )
		{
			$sql = "SELECT count(*) FROM ".$table_category." WHERE pid=".$cid;
			$subCategoriesCountResult = $xoopsDB->query($sql);
			list($subCategoriesCount) = $xoopsDB->fetchRow($subCategoriesCountResult);

			if ( $subCategoriesCount > 0 )
			{
				$sql = "SELECT cid,title FROM ".$table_category." WHERE pid=".$cid;
				$subCategoreisResult = $xoopsDB->query($sql,$num_show,0);
				$subcategories = array();

				while( $subCategory = $xoopsDB->fetchArray($subCategoreisResult) )
				{
					$subcategories[] = "<a href='".$MODULE_URL."/viewcat.php?cid=".$subCategory['cid']."'>".$myts->makeTboxData4Show($subCategory["title"])."</a>";
				}

				$subcategories = implode(", ", $subcategories);

				if ($subCategoriesCount > $num_show)
				{
					$subcategories .= "...";
				}
			}
		}

		$retVars["categories"][] = array(
			'id'            => $cid,
			'imgurl'        => $imgurl_myts,
			'width'         => $width,
			'subcategories' => $subcategories, 
			'totallink'     => $totallink, 
			'count'         => $count,
			'title'         => $myts->makeTboxData4Show($title),
		);

		$count++;
	}

	$retVars["module_url"] = $MODULE_URL;
	$retVars["image_mode"] = $image_mode;
	return $retVars;
}

// by Tom
// --- change function name ---
function b_weblinks_catlist_edit($options)
{
	$image_mode_checked = array('', '', '');
	$image_mode_checked[ $options[1] ] = 'checked';

	$form  = "<table><tr><td>";
	$form .= _MB_WEBLINKS_DISPSUB;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[0]' value='".$options[0]."' />&nbsp;"._MB_WEBLINKS_LINKS."";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_IMAGE_MODE;
	$form .= "</td><td>";
	$form .= "<input type='radio' name='options[1]' value='0' ".$image_mode_checked[0]." />&nbsp;"._MB_WEBLINKS_IMAGE_MODE_0."&nbsp";
	$form .= "<input type='radio' name='options[1]' value='1' ".$image_mode_checked[1]." />&nbsp;"._MB_WEBLINKS_IMAGE_MODE_1."&nbsp";
	$form .= "<input type='radio' name='options[1]' value='2' ".$image_mode_checked[2]." />&nbsp;"._MB_WEBLINKS_IMAGE_MODE_2." ";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MAX_WIDTH;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[2]' value='".$options[2]."' /> ";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_WIDTH_DEFAULT;
	$form .= "</td><td>";
	$form .= "<input type='text' name='options[3]' value='".$options[3]."' /> ";
	$form .= "</td></tr></table>\n";

	return $form;
}

?>