<?php
// $Id: table_manage.php,v 1.2 2006/09/29 12:48:54 ohwada Exp $

// 2006-09-20 K.OHWADA
// this is new file

//================================================================
// RSS Center Module
// 2006-09-10 K.OHWADA
//================================================================

include 'admin_header.php';

//================================================================
// class admin_table_check
//================================================================
class admin_table_check extends happy_linux_error
{
	var $_LIMIT = 100;

	var $_link_handler;

	var $_post;
	var $_form;

	var $_op;
	var $_offset;
	var $_next;
	var $_total;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_table_check()
{
	$this->happy_linux_error();

	$this->_link_handler =& rssc_get_handler('link', RSSC_DIRNAME );

	$this->_post =& happy_linux_post::getInstance();
	$this->_form =& happy_linux_form_lib::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_table_check();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_post_op()
{
	$this->op = $this->_post->get_post_get('op');
	return $this->op;
}

function get_post_offset()
{
	$this->_offset = $this->_post->get_post_int('offset');
	$this->_next   = $this->_offset + $this->_LIMIT;
	return $this->_offset;
}

//---------------------------------------------------------
// check
//---------------------------------------------------------
function menu()
{
	rssc_admin_print_header();
	rssc_admin_print_menu();
	$this->_print_header();
	$this->_form_link();
}

function check_link()
{
	rssc_admin_print_bread( _AM_RSSC_TABLE_MANAGE, 'table_manage.php', 'check link table' );
	$this->_print_header();
	echo "<h4>check link table</h4>\n";

	$offset = $this->get_post_offset();
	$next   = $this->_next;
	if ( $this->_next > $this->_total )
	{
		$next = $this->_total;
	}

	echo "check ".$offset." - ".$next." record <br /><br />\n";

	$count_more = 0;

	$objs =& $this->_link_handler->get_objects_asc($this->_LIMIT, $offset);
	foreach ($objs as $obj)
	{
		$this->_link_handler->set_cache_by_obj( $obj );
		$lid_1    = $obj->get('lid');
		$title_1  = $obj->get('title');
		$rdf_url  = $obj->get('rdf_url');
		$rss_url  = $obj->get('rss_url');
		$atom_url = $obj->get('atom_url');

		$lid_arr =& $this->_link_handler->get_list_by_rssurl( $rdf_url, $rss_url, $atom_url, $lid_1 );
		if ( is_array($lid_arr) && count($lid_arr) )
		{
			echo $this->_build_link_manage($lid_1, $title_1);
			echo " : <b>same links</b> <br />\n";
			$count_more ++;

			foreach ($lid_arr as $lid_2)
			{
				$obj_2 =& $this->_link_handler->getCache( $lid_2 );
				if ( is_object($obj_2) )
				{
					$title_2  = $obj_2->get('title');
					echo " --- ";
					echo $this->_build_link_manage($lid_2, $title_2);
					echo "<br />\n";
				}
			}
		}
	}

	echo "<br />\n";
	
	if ($count_more)
	{
		echo "There are ";
		echo $this->_form->build_html_red($count_more, '', 'bold');
		echo " links which have same links <br />\n";
	}
	else
	{
		echo $this->_form->build_html_blue("Check OK");
		echo "<br />\n";
	}

	if ( $this->_total > $this->_next )
	{
		$this->_form_link($this->_next);
	}
	else
	{
		$this->_print_finish();
	}

}

function _build_link_manage($lid, $title)
{
	$url     = 'link_manage.php?op=mod_form&amp;lid='.$lid;
	$lid_s   = sprintf("%03d", $lid);
	$href    = '<a href="'.$url.'" target="_blank">'.$lid_s.'</a>';
	$title_s = htmlspecialchars($title);
	$text    = $href." : ".$title_s;
	return $text;
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function _print_header()
{
	$this->_total = $this->_link_handler->getCount();

	echo "<h3>"._AM_RSSC_TABLE_MANAGE."</h3>\n";
	echo "check to overlap same RDF/RSS/ATOM url<br />\n";
	echo "There are <b>".$this->_total."</b> links <br />\n";
}

function _form_link($offset=0)
{
	$title = 'check link table';
	$op    = 'check_link';

	if ($offset)
	{
		$submit = "GO next $this->_LIMIT links";
	}
	else
	{
		$submit = 'check link table';
	}

	$this->_print_form_next($title, $op, $submit, $offset);

}

function _print_finish()
{
	echo "<br /><hr />\n";
	echo "<h4>FINISHED</h4>\n";
	echo '<a href="index.php">GOTO Admin Menu</a>'."<br />\n";
}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function _print_form_next($title, $op, $submit, $offset=0)
{
	echo "<br />\n";

	if ($offset)
	{
		$next = $offset + $this->_LIMIT;
		echo "check ".$offset." - ".$next." th record<br />\n";
	}

	$limit = 0;
	$desc  = '';
	echo $this->_form->build_lib_box_limit_offset($title, $desc, $limit, $offset, $op, $submit);
}

// --- class end ---
}


//================================================================
// main
//================================================================

$check =& admin_table_check::getInstance();

$op = $check->get_post_op();

xoops_cp_header();

switch ($op) 
{
case 'check_link':
	$check->check_link();
	break;

case 'menu':
default:
	$check->menu();
	break;

}

xoops_cp_footer();
exit();
// --- main end ---


?>