<?php
// $Id: rssc_refresh_all_handler.php,v 1.5 2006/09/27 03:02:48 ohwada Exp $

// 2006-09-20 K.OHWADA
// use happy_linux_error

// 2006-06-04 K.OHWADA
// use link_basic feed_basic handler
// suppress notice : Only variable references should be returned by reference

// 2006-01-20 K.OHWADA
// small change

//=========================================================
// Rss Center Module
// caller: admin/archive_manage.php & bin/refresh.php
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_refresh_all_handler') ) 
{

//=========================================================
// class rssc_refresh_all_handler
// this class is used by command line
//=========================================================
class rssc_refresh_all_handler extends happy_linux_error
{
// handler
	var $_link_handler;
	var $_feed_handler;
	var $_refresh_handler;

	var $_dirname;

// input
	var $_feed_limit = 0;	// unlimit
	var $_flag_print = 1;
	var $_flag_write = 0;
	var $_fp_result;

// result
	var $_total_link   = 0;
	var $_count_feed   = 0;
	var $_count_broken = 0;

// local
	var $_broken_arr   = array();
	var $_count_link   = 0;

	var $_time_start;
	var $_lid_start;
	var $_lid_end;
	var $_num_feed_cleared;
	var $_num_refresh;
	var $_num_atom_site;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_refresh_all_handler( $dirname )
{
// handler
	$this->_link_handler    =& rssc_get_handler('link_basic', $dirname);
	$this->_feed_handler    =& rssc_get_handler('feed_basic', $dirname);
	$this->_refresh_handler =& rssc_get_handler('refresh',    $dirname);

	$this->_dirname = $dirname;

}

//=========================================================
// public
//=========================================================
//---------------------------------------------------------
// refresh XML archive each link
//---------------------------------------------------------
function refresh($limit=0, $start=0)
{
	$this->_time_start = time();

	$this->_broken_arr   = array();
	$this->_count_link   = 0;
	$this->_count_feed   = 0;
	$this->_count_broken = 0;

	$this->_total_link = $this->_link_handler->get_count_all();
	$lid_arr =& $this->_link_handler->get_id_array($limit, $start);

	$count_lids = count($lid_arr);
	if ($count_lids == 0)
	{
		$data  = '';
		$data .= $this->_get_text_title();
		$data .= $this->_get_text_no_refresh();
		$this->_print_write_data($data);
		return true;	// no action
	}

	$this->_lid_start = $lid_arr[0];
	$this->_lid_end   = $lid_arr[$count_lids - 1];

	$this->_num_refresh = $count_lids;
	$this->_num_feed_cleared = $this->_feed_handler->clear_over_num( $this->_feed_limit );

	$this->_refresh_handler->set_force_refresh(1);

// --- refresh start ---
	$data  = '';
	$data .= $this->_get_text_title();
	$data .= $this->_get_text_html_start();
	$this->_print_write_data($data);

// each link
	foreach($lid_arr as $lid)
	{
		$link_obj =& $this->_link_handler->get_object_by_id($lid);
		if ( !is_object($link_obj) )
		{
			$this->_set_errors( "no link record: lid = $lid" );
			continue;
		}

		$title   = $link_obj->get('title');
		$rss_url = $link_obj->get_rssurl_by_mode();

		if ( empty($rss_url) ) continue;

		if (  $this->_refresh_handler->refresh_by_obj($link_obj) )
		{
			$this->_count_link ++;
			$this->_count_feed += $this->_refresh_handler->get_count_feed();
		}
		else
		{
			$code = $this->_refresh_handler->getErrorCode();
			if ($code == RSSC_CODE_PARSE_FAILED)
			{
				$this->_count_broken ++;
				$this->_broken_arr[] = array($lid, $title, $rss_url);
			}
			else
			{
				$this->_set_errors( $this->_refresh_handler->getErrors() );
				$this->_set_error_code( $code );
			}
		}

		unset($link_obj);
	}

// --- refresh end ---
	$data = $this->_get_text_html_result();
	$this->_print_write_data($data);

	return $this->returnExistError();
}

//---------------------------------------------------------
// get result
//---------------------------------------------------------
function get_total()
{
	return $this->_total_link;
}

function get_count_feed()
{
	return $this->_count_feed;
}

function get_count_broken()
{
	return $this->_count_broken;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_feed_limit($value)
{
	$this->_feed_limit = intval($value);
}

function set_flag_print($value)
{
	$this->_flag_print = intval($value);
}

function set_fp($fp)
{
	$this->_fp_result  = $fp;
	$this->_flag_write = 1;
}


//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// print HTML
//---------------------------------------------------------
function _get_text_html_start()
{
	$time_now = $this->_get_time_now();

	$text = _AM_RSSC_TIME_START." ".$time_now."<br /><br />\n";
	return $text;
}

function _get_text_html_result()
{
	$time_now    = $this->_get_time_now();
	$time_elapse = $this->_get_time_elapse();

	$text = '';

	if ($this->_count_broken)
	{
		$text .= $this->_get_text_table_start();

		foreach ($this->_broken_arr as $broken)
		{
			list($lid, $title, $url) = $broken;
    		$text .= $this->_get_text_table_line($lid, $title, $url);
		}

		$text .= $this->_get_text_table_end();

		$link_broken = "<font color='red'>$this->_count_broken</font>";
	}
	else
	{
		$link_broken = $this->_count_broken;
	}

	$text .= _AM_RSSC_TIME_END." ".$time_now."<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._AM_RSSC_NUM_LINK_TOTAL."</td>";
	$text .= "<td>$this->_total_link "._AM_RSSC_NUM_LINKS."</td></tr>\n";
	$text .= "<tr><td>"._AM_RSSC_NUM_LINK_TARGET."</td>";

	if ($this->_lid_start)
	{
		$text .= "<td>$this->_num_refresh "._AM_RSSC_NUM_LINKS." ( "._RSSC_LINK_ID." $this->_lid_start - $this->_lid_end )</td></tr>\n";
	}
	else
	{
		$text .= "<td>$this->_num_refresh "._AM_RSSC_NUM_LINKS."</td></tr>\n";
	}

	$text .= "<tr><td>"._AM_RSSC_NUM_LINK_BROKEN."</td>";
	$text .= "<td>$link_broken "._AM_RSSC_NUM_LINKS."</td></tr>\n";
	$text .= "<tr><td>"._AM_RSSC_NUM_LINK_UPDATED."</td>";
	$text .= "<td>$this->_count_link "._AM_RSSC_NUM_LINKS."</td></tr>\n";
	$text .= "<tr><td>"._AM_RSSC_NUM_FEED_UPDATED."</td>";
	$text .= "<td>$this->_count_feed "._AM_RSSC_NUM_FEEDS."</td></tr>\n";
	$text .= "<tr><td>"._AM_RSSC_NUM_FEED_CLEARED."</td>";
	$text .= "<td>$this->_num_feed_cleared "._AM_RSSC_NUM_FEEDS."</td></tr>\n";
	$text .= "<tr><td>"._AM_RSSC_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";

	return $text;
}

function _get_text_table_start()
{
	$text  = "<br />\n";
	$text .= "<table border='1'><tr>";
	$text .= "<th align='center'>"._RSSC_LINK_ID."</th>";
	$text .= "<th align='center'>"._RSSC_SITE_TITLE."</th>";
	$text .= "<th align='center'>"._RSSC_RSS_URL."</th>";
	$text .= "</tr>\n";

	return $text;
}

function _get_text_table_line($lid, $title, $url)
{
	$link_id = sprintf("%03d",$lid);
	$jump = XOOPS_URL.'/modules/'.$this->_dirname."/admin/link_manage.php?op=mod_form&amp;lid=".$lid;

	$title_html = $this->_sanitize_html_text($title);
	$href1      = $this->_make_html_url($jump, $link_id);
	$href2      = $this->_make_html_url($url);

	$text  = "<tr>";
	$text .= "<td>".$href1."</td>";
	$text .= "<td>".$title_html."</td>";
	$text .= "<td>".$href2."</td>";
	$text .= "</tr>\n";

	return $text;
}

function _get_text_title()
{
	$text  = "<h4>"._AM_RSSC_REFRESH."</h4>\n";
	return $text;
}

function _get_text_no_refresh()
{
	$text .= _AM_RSSC_NO_REFRESH."<br />\n";
	return $text;
}

function _get_text_table_end()
{
	return "</table><br />\n";
}

function _print_write_data($data)
{
	if ($this->_flag_print)
	{
		echo $data;
	}

	if ($this->_flag_write)
	{
		fwrite($this->_fp_result, $data);
	}
}

//---------------------------------------------------------
// sanitize
//---------------------------------------------------------
function _make_html_url($url, $name='')
{
	$url_html = $this->_sanitize_html_url($url);

	if ($name)
	{
		$name_html = $this->_sanitize_html_text($name);
	}
	else
	{
		$name_html = $url;
	}

	$href = "<a href='$url_html' target='_blank'>$name_html</a>";
	return $href;
}

function _sanitize_html_text($text)
{
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

function _sanitize_html_url($text)
{
	$text = preg_replace('/javascript:/si', 'java script:', $text);
	$text = preg_replace('/&amp;/i', '&', $text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	return $text;
}

//---------------------------------------------------------
// time
//---------------------------------------------------------
function _get_time_now()
{
	$time = date("Y-m-d H:i:s");
	return $time;
}

function _get_time_elapse()
{
	$time = time() - $this->_time_start;
	$min = intval($time/60);
	$sec = $time - 60*$min;
	$ret =  sprintf(_AM_RSSC_MIN_SEC, $min, $sec);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>