<?php
// $Id: convert_encoding.php,v 1.3 2006/09/15 13:59:35 ohwada Exp $

// 2006-09-10 K.OHWADA
// small change

// 2006-07-10 K.OHWADA
// this is new file
// porting from rssc_convert.php

//=========================================================
// Happy Linux Framework Module
// 2006-07-10 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_convert
//=========================================================
class happy_linux_convert_encoding
{
	var $_MAX_DEPTH = 10;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_convert_encoding()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_convert_encoding();
	}
	return $instance;
}

//=========================================================
// public function
//=========================================================
function &convert_array($arr_in, $to, $from)
{
	$ret = $this->_convert_array_recursive(0, $arr_in, $to, $from);
	return $ret;
}

function _convert_array_recursive($num, $arr_in, $to, $from)
{
	$num ++;
	if ( $num > $this->_MAX_DEPTH )
	{	return false;	}

	if ( is_array($arr_in) )
	{
		$arr_out = array();
		reset($arr_in);

		foreach ($arr_in as $k => $v) 
		{
			if ( is_array($v) )
			{
				$arr_out[$k] = $this->_convert_array_recursive($num, $v, $to, $from);
			}
			else
			{
				$arr_out[$k] = $this->convert($v, $to, $from);
			}
		}

		return $arr_out;
	}

	$ret = $this->convert($arr_in, $to, $from);
	return $ret;
}

//---------------------------------------------------------
// multibyte
//---------------------------------------------------------
function convert($str, $to, $from)
{
	if ( $to == $from )
	{
		return $str;
	}

	if ( function_exists('mb_convert_encoding') )
	{
		$str = mb_convert_encoding($str, $to, $from);
	}
	elseif ( strtolower($to) == 'utf-8' )
	{
		$str = utf8_encode($str);
	}
	elseif ( strtolower($from) == 'utf-8' )
	{
		$str = utf8_decode($str);
	}

	return $str;
}

function set_internal_encoding( $encoding='UTF-8' )
{
	if ( function_exists('mb_internal_encoding') )
	{
		mb_internal_encoding( $encoding );
	}
}

// --- class end ---
}

?>