<?php
// $Id: object.php,v 1.5 2006/11/21 02:39:26 ohwada Exp $

// 2006-11-20 K.OHWADA
// for happy_search
// add set_var_checkbox_by_global_post()

// 2006-11-18 K.OHWADA
// BUG 4378: dont strip slashes in conf_value when magic_quotes_gpc is on
// add setBool() getVarBool() etc

// 2006-09-18 K.OHWADA
// add is_set()
// use prepare_text()

// 2006-07-10 K.OHWADA
// this is new file
// porting from weblinks_object_handler.php

//=========================================================
// Happy Linux Framework Module
// 2006-07-10 K.OHWADA
//=========================================================

if( !defined('XOBJ_DTYPE_FLOAT') ) 
{
	define('XOBJ_DTYPE_FLOAT', 12);
	define('XOBJ_DTYPE_BOOL',  13);
}

//=========================================================
// class happy_linux_object
// compatible to XoopsObject
// difference
//   strip GPC slashes when set by serVar()
// base on XopsCube's XoopsSimpleObject
//=========================================================

class happy_linux_object extends happy_linux_strings
{
	var $_vars  = array();
	var $_isnew = false;

	var $_ALLOW_TYPES = array(
		XOBJ_DTYPE_BOOL, 
		XOBJ_DTYPE_INT, 
		XOBJ_DTYPE_FLOAT, 
		XOBJ_DTYPE_TXTBOX, 
		XOBJ_DTYPE_TXTAREA, 
		XOBJ_DTYPE_URL, 
		XOBJ_DTYPE_ARRAY, 
		XOBJ_DTYPE_OTHER,
	);

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_object()
{
	$this->happy_linux_strings();
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function setNew()
{
	$this->_isnew = true;
}

function unsetNew()
{
	$this->_isnew = false;
}

function isNew()
{
	return $this->_isnew;
}

function initVar($key, $dataType, $value = null, $required = false, $size = null)
{
	if (!in_array($dataType, $this->_ALLOW_TYPES)) 
	{	return;	}

	$this->_vars[$key] = array(
		'data_type' => $dataType,
		'value'     => null,
		'required'  => $required ? true : false,
		'maxlength' => $size ? intval($size) : null
	);

	$this->assignVar($key, $value);
}

function is_set($key)
{
	if ( isset($this->_vars[$key]) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// set value just as original
//---------------------------------------------------------
function set($key, $value)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

	switch ($this->_vars[$key]['data_type']) 
	{
		case XOBJ_DTYPE_BOOL:
			$this->setBool($key, $value);
			break;

		case XOBJ_DTYPE_INT:
			$this->setInt($key, $value);
			break;

		case XOBJ_DTYPE_FLOAT:
			$this->setFloat($key, $value);
			break;

		case XOBJ_DTYPE_TXTBOX:
		case XOBJ_DTYPE_TXTAREA:
		case XOBJ_DTYPE_URL:
		case XOBJ_DTYPE_OTHER:
			$this->setAsIs($key, $value);
			break;
	}
}

function setBool($key, $value)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

	$val = 0;
	if ( $value )
	{
		$val = 1;
	}
	$this->_vars[$key]['value'] = $val;
}

function setInt($key, $value)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

	$this->_vars[$key]['value'] = intval($value);
}

function setFloat($key, $value)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

	$this->_vars[$key]['value'] = floatval($value);
}

function setAsIs($key, $value)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

	$this->_vars[$key]['value'] = $value;
}

function assignVar($key, $value)
{
	$this->set($key, $value);
}

function assignVars($values)
{
	foreach ($values as $key => $value) 
	{
		$this->assignVar($key, $value);
	}
}

//---------------------------------------------------------
// get value just as set
//---------------------------------------------------------
function get($key)
{
	return $this->_vars[$key]['value'];
}

function &gets()
{
	$ret = array();
	foreach ($this->_vars as $key => $value) 
	{
		$ret[$key] = $value['value'];
	}
	return $ret;
}

//---------------------------------------------------------
// set value just after formating
//---------------------------------------------------------
function setVar($key, $value, $not_gpc = false)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

	switch ($this->_vars[$key]['data_type']) 
	{
		case XOBJ_DTYPE_BOOL:
			$this->setBool($key, $value);
			break;

		case XOBJ_DTYPE_INT:
			$this->setInt($key, $value);
			break;

		case XOBJ_DTYPE_FLOAT:
			$this->setFloat($key, $value);
			break;

// strip GPC slashes
		case XOBJ_DTYPE_TXTBOX:
			$this->setVarTxtbox($key, $value, $not_gpc);
			break;

// strip GPC slashes
		case XOBJ_DTYPE_TXTAREA:
			$this->setVarTxtarea($key, $value, $not_gpc);
			break;

// strip GPC slashes
		case XOBJ_DTYPE_URL:
			$this->setVarUrl($key, $value, $not_gpc);
			break;

// strip GPC slashes
		case XOBJ_DTYPE_ARRAY:
			$this->setVarArray($key, $value, $not_gpc);
			break;

		case XOBJ_DTYPE_OTHER:
			$this->setAsIs($key, $value);
			break;
	}
}

function setVarTxtbox($key, $value, $not_gpc = false)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

// strip GPC slashes
	$value = $this->prepare_text($value, $not_gpc);

	if ( ($this->_vars[$key]['maxlength'] !== null) && (strlen($value) > $this->_vars[$key]['maxlength']) )
	{
		$this->_vars[$key]['value'] = xoops_substr($value, 0, $this->_vars[$key]['maxlength'], null);
	}
	else
	{
		$this->_vars[$key]['value'] = $value;
	}
}

function setVarTxtarea($key, $value, $not_gpc = false)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

// strip GPC slashes
	$value = $this->prepare_textarea($value, $not_gpc);

	$this->_vars[$key]['value'] = $value;
}

function setVarUrl($key, $value, $not_gpc = false)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

// strip GPC slashes
	$value = $this->prepare_url($value, $not_gpc);

	if ( ($this->_vars[$key]['maxlength'] !== null) && (strlen($value) > $this->_vars[$key]['maxlength']) )
	{
		$this->_vars[$key]['value'] = xoops_substr($value, 0, $this->_vars[$key]['maxlength'], null);
	}
	else
	{
		$this->_vars[$key]['value'] = $value;
	}
}

function setVarArray($key, $value, $not_gpc = false)
{
	if ( !isset($this->_vars[$key]) )
	{	return;	}

// strip GPC slashes
	$value =& $this->prepare_array($value, $not_gpc);

	$this->_vars[$key]['value'] = serialize($value);
}

function setVars($values, $not_gpc = false)
{
	foreach ($values as $key => $value) 
	{
		$this->setVar($key, $value, $not_gpc);
	}
}

function set_var_checkbox_by_global_post( $key, $default=0 )
{
	$val = $default;
	if ( isset($_POST[$key]) )
	{
		$val = $_POST[$key];
	}
	$this->setVar( $key, $val );
}

function set_var_checkbox_by_post( &$post, $key, $default=0 )
{
	$val = $default;
	if ( isset($post[$key]) )
	{
		$val = $post[$key];
	}
	$this->setVar( $key, $val );
}

//---------------------------------------------------------
// get value just after formating
//---------------------------------------------------------
function &getVar($key, $format = 's')
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	switch ($this->_vars[$key]['data_type']) 
	{
		case XOBJ_DTYPE_BOOL:
			$value =& $this->getVarBool($key);
			break;

		case XOBJ_DTYPE_INT:
			$value =& $this->getVarInt($key);
			break;

		case XOBJ_DTYPE_FLOAT:
			$value =& $this->getVarFloat($key);
			break;

		case XOBJ_DTYPE_TXTBOX:
			$value =& $this->getVarTxtbox($key, $format);
			break;

		case XOBJ_DTYPE_TXTAREA:
			$value =& $this->getVarTxtarea($key, $format);
			break;

		case XOBJ_DTYPE_URL:
			$value =& $this->getVarUrl($key, $format);
			break;

		case XOBJ_DTYPE_ARRAY:
			$value =& $this->getVarArray($key);
			break;

		case XOBJ_DTYPE_OTHER:
			$value =& $this->getVarAsIs($key);
			break;
	}

	return $value;
}

function &getVarBool($key)
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = intval( $this->_vars[$key]['value'] );
	return $value;
}

function &getVarInt($key)
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = intval( $this->_vars[$key]['value'] );
	return $value;
}

function &getVarFloat($key)
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = floatval( $this->_vars[$key]['value'] );
	return $value;
}

function &getVarTxtbox($key, $format = 's')
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = $this->_vars[$key]['value'];
	$value = $this->sanitize_format_text($value, $format);
	return $value;
}

function &getVarTxtarea($key, $format = 's')
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = $this->_vars[$key]['value'];
	$value = $this->sanitize_format_textarea($value, $format);
	return $value;
}

function &getVarUrl($key, $format = 's')
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = $this->_vars[$key]['value'];
	$value = $this->sanitize_format_url($value, $format);
	return $value;
}

function &getVarArray($key)
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = $this->_vars[$key]['value'];
	$value = unserialize($value);
	return $value;
}

function &getVarAsIs($key)
{
	$value = null;

	if ( !isset($this->_vars[$key]) )
	{	return $value;	}

	$value = $this->_vars[$key]['value'];
	return $value;
}

function &getVarAll($format='n')
{
	$ret = array();
	foreach ($this->_vars as $k => $v) 
	{
		$ret[$k] = $this->getVar($k, $format);
	}
	return $ret;
}

//---------------------------------------------------------
// set utility
//---------------------------------------------------------
function set_var_by_post($post, $key)
{
	if ( isset($post[$key]) )
	{
		$this->setVar( $key, $post[$key] );
	}
}

function _set_vars_insert()
{
	$this->setVars( $_POST );
}

function _set_vars_update()
{
	$this->setVars( $_POST );
}

//---------------------------------------------------------
// get utility
//---------------------------------------------------------
function get_var_url_null($key, $format='s', $default='http://')
{
	$url   = $this->get($key);
	$value = $this->substute_http($value, $default);
	$value = $this->sanitize_format_url($value, $format);
	return $value;
}

function get_var_text_short($key, $format='s', $max=100)
{
	$value = $this->get($key);
	$value = $this->sanitize_format_text_short($value, $format, $max);
	return $value;
}

}
// --- class end ---

?>