<?php
// $Id: bin_refresh_class.php,v 1.6 2007/05/20 02:08:54 ohwada Exp $

// 2007-05-20 K.OHWADA
// change check()

// 2006-07-10 K.OHWADA
// use happy_linux_bin_base

// 2006-07-01 K.OHWADA
// BUG 4083: The command line of refreshed links are limited to 10 sites.

// 2006-06-04 K.OHWADA
// not use xoopsConfig
// suppress notice : Only variable references should be returned by reference

//=========================================================
// Rss center Module
// 2006-01-01 K.OHWADA
//=========================================================
class bin_refresh extends happy_linux_bin_base
{
// class Instant
	var $_refresh;
	var $_config;

// constant
	var $_TITLE           = 'refresh archive';
	var $_FILENAME_RESULT = 'refresh_link.html';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function bin_refresh( $dirname )
{
	$this->happy_linux_bin_base( $dirname );
	$this->set_mailer( 'XOOPS rssc' );

// class Instant
	$this->_refresh =& rssc_get_handler( 'refresh_all',  $dirname );
	$this->_config  =& rssc_get_handler( 'config_basic', $dirname );

// result file
	$this->set_result_file( $this->_FILENAME_RESULT );
}

//=========================================================
// public
//=========================================================
function refresh()
{
	$conf_data  =& $this->_config->get_conf();
	$feed_limit =  $conf_data['basic_feed_limit'];
	$pass       =  $conf_data['bin_pass'];
	$mailto     =  $conf_data['bin_mailto'];
	$flag_send  =  $conf_data['bin_send'];

	if ( !$this->_set_env_param($pass) )
	{
		return false;
	}

	$this->_refresh->set_feed_limit($feed_limit);
	$this->_refresh->set_flag_print($this->_flag_print);

// --- file open ---
	$this->_file_open();

	if ($this->_flag_write && $this->_fp)
	{
		$this->_refresh->set_fp($this->_fp);
	}

	$this->_html_header();

	$this->_refresh->refresh($this->_limit);

	$this->_html_footer();
	$this->_file_close();
// --- file close ---

	if ($flag_send)
	{
		$total       = $this->_refresh->get_total();
		$num_broken  = $this->_refresh->get_count_broken();
		$num_feed    = $this->_refresh->get_count_feed();

// mail
		$text = <<<END_OF_TEXT
total  links:  $total
broken links:  $num_broken
refresh feeds: $num_feed
END_OF_TEXT;

		$this->_send_mail($mailto, $this->_TITLE, $text);
	}

	return true;
}

// --- class end ---
}

?>