//=========================================================
// overlib image popup
// require overlib.js
// 2007-04-15 K.OHWADA
//=========================================================

var OVERLIB_IMAGE_LIMIT_WIDTH   = 600;
var OVERLIB_IMAGE_LIMIT_HEIGHT  = 450;
var OVERLIB_IMAGE_MARGIN_Y      = 50;

function overlib_image_popup( filename ) 
{

// position x
	x = ( windowWidth() - OVERLIB_IMAGE_LIMIT_WIDTH ) / 2;
	if ( x < 0 ) { x = 0; }

// upper margin
	margin = o3_y - overlib_image_page_offset_y() - OVERLIB_IMAGE_MARGIN_Y;

// image size
	size   = overlib_image_size( filename, OVERLIB_IMAGE_LIMIT_WIDTH, OVERLIB_IMAGE_LIMIT_HEIGHT );
	width  = size[0];
	height = size[1];

// html img tag
	if (width) {
		html = '<img src="' + filename + '" width="' + width + '" height="' + height + '" />';
	} else {
		html = '<img src="' + filename + '" width="' + OVERLIB_IMAGE_LIMIT_WIDTH + '" />';
	}

// show image
	if ( margin > height ) {
		return overlib(html, RELX, x, OFFSETY, OVERLIB_IMAGE_MARGIN_Y, ABOVE);
	} else {
		return overlib(html, RELX, x, OFFSETY, OVERLIB_IMAGE_MARGIN_Y );
	}
}

// get Browser page offset
function overlib_image_page_offset_y() 
{
	offset = (olIe4) ? eval('o3_frame.'+docRoot+'.scrollTop') : o3_frame.pageYOffset;
	return offset;
}

// get image size
function overlib_image_size( filename, limit_width, limit_height )
{
	image = new Image();
	image.src = filename;

// bigger than width limit
	if ( image.width > limit_width ) {
		width  = limit_width;
		height = image.height * limit_width / image.width;
	} else {
		width  = image.width;
		height = image.height;
	}

// bigger than height limit
	if ( height > limit_height ) {
		width  = width * limit_height / height;
		height = limit_height;
	}

	arr = new Array();
	arr[0] = width;
	arr[1] = height;

	return arr;
}
