<?php
// $Id: weblog_updates.class.php,v 1.2 2009/03/08 20:37:50 ohwada Exp $

//=========================================================
// weblog updated ping
// 2009-03-08 K.OHWADA
//=========================================================

//=========================================================
// class weblog_updates
//=========================================================

//---------------------------------------------------------
// weblogUpdates.ping
// http://www.xmlrpc.com/weblogsCom
//---------------------------------------------------------

class weblog_updates
{
// result
	var $_errors = array();

// input param
	var $_weblog_name;
	var $_weblog_url;

// response form ping server
	var $_response_code;
	var $_response_reason;
	var $_response_error;

// snoopy
	var $_snoopy_status;
	var $_snoopy_error;
	var $_snoopy_response_code;
	var $_snoopy_results;

	var $_SNOOPY_PORT          = 80;
	var $_SNOOPY_HTTP_METHOD  = 'POST';
	var $_SNOOPY_CONTENT_TYPE = 'text/xml';
	var $_SNOOPY_READ_TIMEOUT = 10;

// timestamp file
	var $_TIME_UPDATED_MARGIN = 86400;	// 10 sec
	var $_TIME_SEND_MARGIN    = 60;	// 60 sec

// return code
	var $_RET_SUCCESS   =  1;
	var $_RET_FAIL      = -1;
	var $_RET_NO_ACTION = 0;

// log file
	var $_fp      = null ;
	var $_use_log = false ;

// for debug
	var $_flag_print = false ;
	var $_flag_print_detail = false ;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblog_updates()
{
	// dummy
}

//---------------------------------------------------------
// main function
//---------------------------------------------------------
function send_pings_with_check_time( $param )
{
	$timestamp_file = isset($param['timestamp_file']) ? $param['timestamp_file'] : null;
	$updated_time   = isset($param['updated_time'])   ? intval($param['updated_time']) : 0;

	$time_stamp = 0 ;

	if ( empty($timestamp_file) ) {
		$this->set_error( 'not set timestamp_file' );
		return $this->_RET_FAIL ;
	}

	if ( is_file($timestamp_file) ) {
		if ( ! is_writable($timestamp_file) ) {
			$this->set_error( 'not writable timestamp_file: '.$timestamp_file );
			return $this->_RET_FAIL ;
		}
		$time_stamp = intval( trim( file_get_contents( $timestamp_file ) ) );

	} else {
		$ret = touch( $timestamp_file );
		if ( !$ret ) {
			$this->set_error( 'not create timestamp_file: '.$timestamp_file );
			return $this->_RET_FAIL ;
		}
	}

// send within 10 sec
	if ( $updated_time < ( $time_stamp - $this->_TIME_UPDATED_MARGIN ) ) {
		return $this->_RET_NO_ACTION ;
	}

// not send within 60 sec
	if ( time() < ( $time_stamp + $this->_TIME_SEND_MARGIN ) ) {
		return $this->_RET_NO_ACTION ;
	}

	$ret = $this->send_pings_by_param( $param );

	$fp = fopen( $timestamp_file, "w" );
	if ( $fp ) {
		fwrite( $fp, time() );
		fclose( $fp );

	} else {
		$this->set_error( 'not open timestamp_file: '.$timestamp_file );
		return $this->_RET_FAIL ;
	}

	if ( $ret ) {
		return $this->_RET_SUCCESS;
	}

	return $this->_RET_FAIL ;
}

function send_pings_by_param( $param )
{
	$flag_error = false;

// param
	$site_name    = $param['site_name'];
	$site_url     = $param['site_url'];
	$ping_servers = $param['ping_servers'];

	$print_level  = isset($param['print_level']) ? intval($param['print_level']) : 0;
	$log_level    = isset($param['log_level'])   ? intval($param['log_level'])   : 0;
	$log_file     = isset($param['log_file'])    ? $param['log_file']            : null;

// check
	if ( $site_name ) {
		$this->_weblog_name = $site_name;
	} else {
		$this->set_error( 'no weblog name' );
		return false;
	}

	if ( $site_url ) {
		$this->_weblog_url  = $site_url;
	} else {
		$this->set_error( 'no weblog url' );
		return false;
	}

	if ( !is_array($ping_servers) || !count($ping_servers) ) {
		$this->set_error( 'no ping server' );
		return false;
	}

	if ( $print_level >= 2 ) {
		$this->_flag_print = true ;
	}
	if ( $print_level >= 3 ) {
		$this->_flag_print_detail = true ;
	}
	if ( ( $log_level > 0 ) && $log_file ) {
		$this->open_log( $log_file );
		$this->write_log( date("Y/m/d H:i:s")."\n" );
	}

	$this->print_msg( "=== \n" );

// send ping
	foreach ($ping_servers as $url)
	{
		$url = trim($url);
	 	if ( empty($url) ) {
	 		continue;
		}

		$ret = $this->send_single_ping( $url );
		if ( !$ret ) {
			$flag_error = true;
		}

	}

	$this->print_msg( "=== \n" );
	$this->close_log();

	return !$flag_error;
}

//---------------------------------------------------------
// send ping to server
// $url  : server url
// $code : return code
//---------------------------------------------------------
function send_single_ping($url)
{
	$code   = 1;	// NG
	$reason = '';
	$error  = '';

// make message
	$payload = $this->build_payload();

// print message
	if ( $this->_flag_print_detail ) 
	{
		echo "---SEND--- \n";
		echo $url;
		echo "\n";
		echo "--- \n";
		echo $payload;
		echo "\n";
		echo "--- \n";
	}

// send ping
	$ret = $this->snoopy_request( $url, $payload );
	if ( $ret ) {
		list( $code, $reason ) = $this->parse_response( $this->_snoopy_results );
	} else {
		$error = $this->_snoopy_error ;
		$thjs->set_error( $error );
	}

// print message
	if ( $this->_flag_print_detail ) 
	{
		echo "---RESPONSE--- \n";
		echo $this->_snoopy_response_code;
		echo "\n\n";
		echo $this->_snoopy_results;
		echo "--- \n";
	}

	$msg = $this->make_result( $url, $code, $reason, $error );
	$this->print_msg( $msg );
	$this->write_log( $msg );

	if ( $code == 0 ) {
		return true;
	}
	return false;
}

//---------------------------------------------------------
//  build_payload
//---------------------------------------------------------
function build_payload()
{
	$str = <<<END_OF_TEXT
<?xml version="1.0"?>
<methodCall>
  <methodName>weblogUpdates.ping</methodName>
   <params>
   <param>
     <value>$this->_weblog_name</value>
   </param>
   <param>
     <value>$this->_weblog_url</value>
   </param>
   </params>
</methodCall>
END_OF_TEXT;

	return $str;
}

//---------------------------------------------------------
//   parse response
//---------------------------------------------------------
// --- success ---
// <methodResponse>
//   <params>
//   <param>
//   <value>
//   <struct>
//     <member>
//       <name>flerror</name>
//       <value>
//       <boolean>0</boolean>
//       </value>
//     </member>
//     <member>
//       <name>message</name>
//       <value>Thanks for the ping.</value>
//     </member>
//   </struct>
//   </value>
//   </param>
//   </params>
// </methodResponse>
//
// --- fault ---
// <methodResponse>
//    <fault>
//    <value>
//    <struct>
//      <member>
//        <name>faultCode</name>
//        <value><int>***</int></value>
//      </member>
//      <member>
//        <name>faultString</name>
//        <value><string>***</string></value>
//      </member>
//   </struct>
//   </value>
//   </fault>
// </methodResponse>
//---------------------------------------------------------
function parse_response($response)
{
	$error   = 1;
	$message = 'no message';

	$member_arr = $this->parse_xml($response);

// print message
	if ( $this->_flag_print_detail ) 
	{
		echo "--- PARSE --- \n";
		foreach ( $member_arr as $name => $value ) {
			echo "$name: $value \n";
		}
		echo "--- \n";
	}

	if ( isset($member_arr['flerror']) ) {
		$error   = $member_arr['flerror'];
		$message = $member_arr['message'];

	} elseif ( isset($member_arr['faultCode']) ) {
		$error   = $member_arr['faultCode'];
		$message = $member_arr['faultString'];
	}

	return array($error, $message);
}

//---------------------------------------------------------
//   parse xml
//---------------------------------------------------------
function parse_xml($xml)
{
	preg_match_all('/<member>(.*?)<\/member>/is', $xml, $match1);
	$arr = $match1[1];

	$member_arr = array();

	foreach ($arr as $member)
	{
		if (preg_match('/<name>(.*)<\/name>/is', $member, $match2)) {
			$name = trim( $match2[1] );
		}

		if (preg_match('/<value>(.*)<\/value>/is', $member, $match2)) {
			$value1 = $match2[1];
			$value2 = $value1;

			if (preg_match('/<boolean>(.*)<\/boolean>/is', $value1, $match3)) {
				$value2 = trim( $match3[1] );
			}

			if (preg_match('/<int>(.*)<\/int>/is', $value1, $match3)) {
				$value2 = trim( $match3[1] );
			}

			if (preg_match('/<string>(.*)<\/string>/is', $value1, $match3)) {
				$value2 = trim( $match3[1] );
			}
		}

		$member_arr[$name] = $value2;
	}

	return $member_arr;
}

//---------------------------------------------------------
// make result message
// $list : result list
// $msg  : result message
//---------------------------------------------------------
function make_result( $url, $code, $reason, $error )
{
	if ( $code == 0 ) {
		$msg = "ping send - " . $url . " - OK \n";

	} else {
		$msg = 'ping send - ' . $url ." - ERROR \n";

		if ( $error) {
			$msg .= $error . "\n";
		}
		if ( $reason) {
			$msg .= $reason . "\n";
		}
	}
	return $msg;
}

//---------------------------------------------------------
// debug print
//---------------------------------------------------------
function print_msg( $msg )
{
	if ( $this->_flag_print ) {
		echo $msg ;
	}
}

//---------------------------------------------------------
// log file
//---------------------------------------------------------
function open_log( $log_file )
{
	$fp = fopen( $log_file, "a" );
	if ( $fp ) {
		$this->_fp      = $fp ;
		$this->_use_log = true;
	}
}

function write_log( $msg )
{
	if ( $this->_use_log ) {
		fwrite( $this->_fp, $msg );
	}
}

function close_log()
{
	if ( $this->_use_log ) {
		fclose( $this->_fp );
	}
}

//---------------------------------------------------------
// error
//---------------------------------------------------------
function set_error($err)
{
	$this->_errors[] = $err;
}

function get_errors()
{
	return $this->_errors;
}

//---------------------------------------------------------
//  snoopy class
//---------------------------------------------------------
function snoopy_request( $url, $payload )
{
	$this->_snoopy_error         = '';
	$this->_snoopy_status        = 0;
	$this->_snoopy_response_code = '';
	$this->_snoopy_results       = '';

	$port = $this->_SNOOPY_PORT;

	$snoopy = new Snoopy();
	$snoopy->read_timeout = $this->_SNOOPY_READ_TIMEOUT ;

	$uri_parts = parse_url($url);
	if ( !empty($uri_parts["host"]) ) {
		$snoopy->host = $uri_parts["host"];
	} else {
		$this->_snoopy_error = 'no host in url' ;
		return false;
	}
	if ( !empty($uri_parts["port"]) ) {
		$port = $uri_parts["port"];
	}
	if ( !empty($uri_parts["path"]) ) {
		$path = $uri_parts["path"];
	}

	$snoopy->port = $port;

// set $fp in _connect()
	$snoopy->_connect($fp);
	$ret = $snoopy->_httprequest( 
		$path, $fp, $url, $this->_SNOOPY_HTTP_METHOD, $this->_SNOOPY_CONTENT_TYPE, $payload );
	$snoopy->_disconnect($fp);

	if ( !$ret ) {
		$this->_snoopy_error         = $snoopy->error ;
		$this->_snoopy_status        = $snoopy->status ;
		$this->_snoopy_response_code = $snoopy->response_code ;
		return false;
	}

	$this->_snoopy_response_code = $snoopy->response_code ;
	$this->_snoopy_results       = $snoopy->results ;

	return true;
}

// --- class end ---
}

?>