﻿<?php
/**
 * @package exauth
 * @subpackage language_japanese
 * @version $Id: main.php 238 2009-03-14 07:22:51Z kisara $
 */

/**#@+ Message Define */
define('_MD_EXAUTH_AUTH', '認証');
define('_MD_EXAUTH_ID', '外部認証ID');

define('_MD_EXAUTH_AUTH_FAILED', '認証に失敗しました。');
define('_MD_EXAUTH_REGIST_DONE', '登録が完了しました。');
define('_MD_EXAUTH_PLEASE_INPUT_EMAIL', 'ご利用にはメールアドレスを登録していただく必要があります。');
define('_MD_EXAUTH_PLEASE_INPUT_UNAME', 'ご利用には当サイト用のユーザ名を登録していただく必要があります。');
define('_MD_EXAUTH_PLEASE_INPUT_UNAME_EMAIL', 'ご利用には当サイト用のユーザ名、メールアドレスを登録していただく必要があります。');
define('_MD_EXAUTH_PLEASE_INPUT_ATTACH', 'すでにアカウントをお持ちの場合はこちらから関連付けすることができます。<br />パスワードログインの無効化をされてる場合はログインしてから外部認証してください。');
define('_MD_EXAUTH_PLEASE_INPUT_ATTACH_LOGIN', '関連付けを行うユーザ名とパスワードを入力してください。');
define('_MD_EXAUTH_PLEASE_INPUT_ATTACH_BUTTON', '関連付け');
define('_MD_EXAUTH_ID_ALREADY_USED', '外部認証IDと同じIDはすでに使用されています。違うIDをご登録ください');

define('_MD_EXAUTH_REGIST_SUBMIT', '登録');
define('_MD_EXAUTH_EXECUTE', '実行');

define('_MD_EXAUTH_DETACH_REQUIRE_PASSWORD', '関連付けを削除するためにはパスワードの設定が必要です');
define('_MD_EXAUTH_ENABLE_PASSWORD_REQUIRE', 'パスワードログインを有効にするためにはパスワードの設定が必要です');

define('_MD_EXAUTH_DISABLE_PASSWORD', 'パスワードログインの無効化');
define('_MD_EXAUTH_ENABLE_PASSWORD', 'パスワードログインを有効にする');
define('_MD_EXAUTH_DETACH', '関連付けの削除');
define('_MD_EXAUTH_DETACH_FINISH', '関連付けを削除しました');

define('_MD_EXAUTH_ATTACH_OK', '外部認証ID %s とユーザ %s を関連付けてよろしいですか？');
define('_MD_EXAUTH_DETACH_OK', '関連付けを削除します。よろしいですか？');
define('_MD_EXAUTH_REGIST_OK', '%s さん、ようこそ！ユーザ名 %s で登録しますがよろしいですか？<br />(登録後にユーザ名は変更出来ないので注意してください。)');
define('_MD_EXAUTH_REREGIST_OK', '%s さん、ようこそ！以前のユーザ名 %s で登録しますがよろしいですか？');
define('_MD_EXAUTH_DISABLE_PASS_OK', 'パスワードログインを使用不可にします。よろしいですか？');
define('_MD_EXAUTH_DISABLE_PASS_FINISH', 'パスワードログインを使用不可にしました');
define('_MD_EXAUTH_ENABLE_PASS_FINISH', 'パスワードログインを有効にしました');

define('_MD_EXAUTH_INVALID_PARAM', '不正なパラメタです');
define('_MD_EXAUTH_NOT_LOGIN', 'ログインしていません');
define('_MD_EXAUTH_LOGINED', 'ログインしています');

define('_MD_EXAUTH_ANOTHOER_USER_REGISTED1', 'その外部IDは別のユーザで登録されています。');
define('_MD_EXAUTH_ANOTHOER_USER_REGISTED2', 'ログアウトしてから外部認証でログインしなおすか、認証サービスからログアウトしてください。');

define('_MD_EXAUTH_GOTO_AUTH_PAGE', '%s の認証ページへ移動します');

define('_MD_EXAUTH_ACTLOGIN','アカウントを承認しました。%s 認証を使用してログインしてください。');

define('_MD_EXAUTH_ID_TOO_SHORT', '外部認証IDと同じIDでは短すぎるので、同じIDでは登録できません。');
define('_MD_EXAUTH_ID_TOO_LONG', '外部認証IDと同じIDでは長すぎるので、同じIDでは登録できません。');
define('_MD_EXAUTH_CANT_DETACH', '自動ID割り当てなので、関連付けは削除できません。');

#define('_EXAUTH_USING_REGIST', 'を利用して登録する場合はこちらから。');
define('_MD_EXAUTH_USING_EXAUTH_LOGIN_REGIST', '外部認証を利用してログイン／登録');
#define('_EXAUTH_USING_EXAUTH_HERE', 'ログインまたは新規登録はこちらから。');

define('_MD_EXAUTH_EXTERNAL_AUTH_SUCCESS', '認証に成功しました。下記事項をご記入して登録してください。');

define('_MD_EXAUTH_MESSAGE_ACTLOGIN', 'アカウントを承認しました。各種認証経由でログインしてください。');

define('_MD_EXAUTH_FORM_REQUIRE_VALUE', 'を入力してください。');
define('_MD_EXAUTH_FORM_NUMBER_ONLY', 'は数値のみを入力してください。');
define('_MD_EXAUTH_FORM_VALUE_DONT_EXIST', 'は指定外の値です。');
define('_MD_EXAUTH_FORM_INVALID_MAIL', 'は不正なメールアドレスです。');
define('_MD_EXAUTH_FORM_INVALID_DATE', 'は不正な日付です。');
define('_MD_EXAUTH_FORM_INVALID_TIME', 'は不正な時間です。');

define('_MD_EXAUTH_AUTO_ASSIGN_UNAME', '自動割り当て');
define('_MD_EXAUTH_INPUT_UNAME', '手動入力');
define('_MD_EXAUTH_LANG_REQUIRE_FIELD', 'は入力必須項目です。');
define('_MD_EXAUTH_LANG_INVALID_AUTO_UNAME', 'ユーザ名の選択方法が間違っています。');

define('_MD_EXAUTH_ATTACH_CONFIRM', '以下の外部認証システムの認証IDでログインできるようにします。');

define('_MD_EXAUTH_LOGIN_OR_REGIST', 'ログインまたは新規登録');
define('_MD_EXAUTH_ATTACH', '現在のアカウントと関連付ける');

define('_MD_EXAUTH_IFNOTRELOAD_POST', 'ページが自動的に更新されない場合は %s をクリックしてください');
define('_MD_EXAUTH_IFNOTRELOAD_BUTTON', 'ここ');

define('_MD_EXAUTH_ALREADY_ASSOC', 'ご指定のアカウントは既に別の外部認証IDが関連づけられています。このIDで上書きしますか？');
define('_MD_EXAUTH_ALREADY_ASSOC_CANCEL', '関連付けを中止しました。登録されている外部認証IDでログインしてください。');

// from user module
define('_MD_EXAUTH_MESSAGE_ACTKEYNOT', '承認キーが間違っています。');
define('_MD_EXAUTH_MESSAGE_ACONTACT', "選択されたアカウントは既に承認が完了しています。");
define('_MD_EXAUTH_MESSAGE_ACTVMAILOK', "%sさんへメールを送信しました。");
define('_MD_EXAUTH_MESSAGE_ACTVMAILNG', "%sさんへのメール送信に失敗しました。");
define('_MD_EXAUTH_MESSAGE_YOURREGISTERED', "登録が完了しました。記載されたメールを登録メールアドレス宛に承認キーを送信しました。メールの指示に従い、承認を完了してください。");
define('_MD_EXAUTH_MESSAGE_YOURREGISTERED2', "登録が完了しました。サイト管理者がアカウントを承認するまでお待ちください。承認完了時にはメールにてお知らせします。");
define('_MD_EXAUTH_MESSAGE_IAGREE', "私は上記事項に同意します。");

#define('_MD_EXAUTH_LANG_ALLABOUT', "%sさんの基本情報");
#define('_MD_EXAUTH_LANG_ASSIGN', "割り当て");
#define('_MD_EXAUTH_LANG_ATTACHSIG', "投稿に署名を必ず追加する");
#define('_MD_EXAUTH_LANG_AVATAR', "アバター");
#define('_MD_EXAUTH_LANG_AVATAR_EDIT', "アバター編集");
#define('_MD_EXAUTH_LANG_AVATAR_ID', "ID");
#define('_MD_EXAUTH_LANG_AVATAR_LIST', "使用可能アバター一覧");
#define('_MD_EXAUTH_LANG_AVATAR_MAXFILESIZE', "最大ファイルサイズ");
#define('_MD_EXAUTH_LANG_AVATAR_WIDTH', "幅");
#define('_MD_EXAUTH_LANG_AVATAR_WIDTH_HIGHT', "幅 x 高さ");
#define('_MD_EXAUTH_LANG_BIO', "その他");
#define('_MD_EXAUTH_LANG_DELACCOUNT', "アカウントを削除する");
#define('_MD_EXAUTH_LANG_DELETE', "削除");
define('_MD_EXAUTH_LANG_DISCLAIMER', "免責");
#define('_MD_EXAUTH_LANG_EDITPROFILE', "プロフィールの編集");
define('_MD_EXAUTH_LANG_EMAIL', "メールアドレス");
define('_MD_EXAUTH_LANG_FINISH', "送信");
#define('_MD_EXAUTH_LANG_GROUPID', "グループID");
#define('_MD_EXAUTH_LANG_GUEST', "ゲスト");
define('_MD_EXAUTH_LANG_HASJUSTREG', "新規登録ユーザがありました！　ユーザ名：%s");
define('_MD_EXAUTH_LANG_INVALIDNICKNAME', "不正なユーザ名です。");
#define('_MD_EXAUTH_LANG_LAST_LOGIN', "最終ログイン日時");
#define('_MD_EXAUTH_LANG_LEVEL', "レベル");
#define('_MD_EXAUTH_LANG_LOSTPASSWORD', "パスワードを紛失されましたか？");
#define('_MD_EXAUTH_LANG_NAME', "本名");
define('_MD_EXAUTH_LANG_NAMERESERVED', "このユーザ名は使用できません。");
#define('_MD_EXAUTH_LANG_NEWPWDREQ', "新規パスワードのリクエスト＠%s");
define('_MD_EXAUTH_LANG_NEWUSERREGAT', "新規登録ユーザ＠%s");
define('_MD_EXAUTH_LANG_NICKNAME', "ユーザ名");
define('_MD_EXAUTH_LANG_NICKNAMETAKEN', "このユーザ名は既に使用されています");
#define('_MD_EXAUTH_LANG_NO', "いいえ");
#define('_MD_EXAUTH_LANG_NOACTTPADM', "選択されたユーザはまだ存在しないか、承認が完了していません。");
#define('_MD_EXAUTH_LANG_NOPROBLEM', "ご心配なく。まずはあなたが登録に使用したメールアドレスを入力し、ボタンをクリックしてください。 パスワード取得用のリンクが記載されたメールがあなたの登録メールアドレス宛に送られます。");
define('_MD_EXAUTH_LANG_NOREGISTER', "申し訳ございませんが、現在このサイトでは新規ユーザの登録受付を行っておりません。");
define('_MD_EXAUTH_LANG_NOTIFY_METHOD', "イベント更新通知メッセージの受取方法");
#define('_MD_EXAUTH_LANG_NOTIFY_MODE', "イベント通知のタイミング");
#define('_MD_EXAUTH_LANG_NOTREGISTERED', "今すぐ登録？");
define('_MD_EXAUTH_LANG_PASS', "パスワード");
define('_MD_EXAUTH_LANG_PASSWORD', "パスワード");
#define('_MD_EXAUTH_LANG_PM', "PM");
#define('_MD_EXAUTH_LANG_POSTS', "投稿数");
#define('_MD_EXAUTH_LANG_PROFILE', "プロフィール");
#define('_MD_EXAUTH_LANG_RANK', "ランク");
#define('_MD_EXAUTH_LANG_RANK_ID', "ID");
define('_MD_EXAUTH_LANG_REGISTER', "登録");
define('_MD_EXAUTH_LANG_REGISTERNG', "登録できませんでした");
#define('_MD_EXAUTH_LANG_REMOVEINFO', "アカウントを削除した場合、全てのユーザ情報が失われます。");
#define('_MD_EXAUTH_LANG_SAVECHANGES', "変更を保存");
#define('_MD_EXAUTH_LANG_SELECT', "選択");
#define('_MD_EXAUTH_LANG_SENDPASSWORD', "送信");
#define('_MD_EXAUTH_LANG_SHOWALL', "すべて表示");
#define('_MD_EXAUTH_LANG_STATISTICS', "統計情報");
define('_MD_EXAUTH_LANG_SUBMIT', "送信");
#define('_MD_EXAUTH_LANG_THEME', "テーマ");
define('_MD_EXAUTH_LANG_TIMEZONE', "タイムゾーン");
define('_MD_EXAUTH_LANG_TIMEZONE_OFFSET', "タイムゾーン");
#define('_MD_EXAUTH_LANG_TYPEPASSTWICE', "（パスワードを変更する場合のみ記入してください）");
#define('_MD_EXAUTH_LANG_UID', "UID");
#define('_MD_EXAUTH_LANG_UMODE', "コメント表示モード");
define('_MD_EXAUTH_LANG_UNAME', "ユーザー名");
#define('_MD_EXAUTH_LANG_UNASSIGN', "割り当て解除");
#define('_MD_EXAUTH_LANG_UORDER', "コメントの並び順");
define('_MD_EXAUTH_LANG_URL', "ホームページ");
#define('_MD_EXAUTH_LANG_USER_AIM', "AIM");
#define('_MD_EXAUTH_LANG_USER_AVATAR', "アバター");
#define('_MD_EXAUTH_LANG_USER_FROM', "居住地");
#define('_MD_EXAUTH_LANG_USER_ICQ', "ICQ");
#define('_MD_EXAUTH_LANG_USER_INTREST', "趣味");
#define('_MD_EXAUTH_LANG_USER_MAILOK', "当サイトの新着情報などをメールで受け取る");
#define('_MD_EXAUTH_LANG_USER_MSNM', "MSNM");
#define('_MD_EXAUTH_LANG_USER_OCC', "職業");
#define('_MD_EXAUTH_LANG_USER_REGDATE', "登録日");
#define('_MD_EXAUTH_LANG_USER_SIG', "署名");
define('_MD_EXAUTH_LANG_USER_VIEWEMAIL', "このメールアドレスを公開する");
#define('_MD_EXAUTH_LANG_USER_YIM', "YIM");
#define('_MD_EXAUTH_LANG_USERCOOKIE', "ユーザ名を１年間クッキーに保存する");
define('_MD_EXAUTH_LANG_USERKEYFOR', "%sさんの承認キーです");
define('_MD_EXAUTH_LANG_USERREG', "ユーザ登録");
define('_MD_EXAUTH_LANG_VERIFYPASS', "パスワード確認");
define('_MD_EXAUTH_LANG_WEBSITE', "ホームページ");
#define('_MD_EXAUTH_LANG_WHOSONLINE', "オンライン状況");
define('_MD_EXAUTH_LANG_YOURACCOUNT', "%sでのユーザアカウント");
#define('_MD_EXAUTH_LANG_YOUREMAIL', "登録メールアドレス：");

#define('_MD_EXAUTH_ERROR_DBUPDATE_FAILED', "データベースの更新に失敗しました");
define('_MD_EXAUTH_ERROR_EMAIL', "{0}は不正なメールアドレスです");
define('_MD_EXAUTH_ERROR_EMAILTAKEN', "このメールアドレスは既に使用されています");
define('_MD_EXAUTH_ERROR_INJURY', "{0}の入力値が不正です");
define('_MD_EXAUTH_ERROR_INVALID_EMAIL', "不正なメールアドレスです");
define('_MD_EXAUTH_ERROR_MAXLENGTH', "{0}は半角{1}文字以内で入力して下さい");
define('_MD_EXAUTH_ERROR_MINLENGTH', "{0}は半角{1}文字以上にして下さい");
#define('_MD_EXAUTH_ERROR_NAME_RESERVED', "このユーザ名は使用できません。");
define('_MD_EXAUTH_ERROR_PASSWORD', "パスワードと確認用パスワードが一致しません");
define('_MD_EXAUTH_ERROR_REQUIRED', "{0}は必ず入力して下さい");
#define('_MD_EXAUTH_ERROR_SEND_MAIL', "メールの送信に失敗しました。管理者に御連絡下さい。");
define('_MD_EXAUTH_ERROR_TIMEZONE', "タイムゾーン");
define('_MD_EXAUTH_ERROR_UNEEDAGREE', "申し訳ございませんが、登録するためには免責事項にご同意いただく必要があります。");
#define('_MD_EXAUTH_ERROR_YOURREGMAILNG', "登録が完了しました。しかし、サーバ内部エラーにより承認キーが記載されたメールを送信することができませんでした。大変申し訳ありませんが、サイト管理者までお問い合わせください。");

define('_MD_EXAUTH_ERROR_INCORRECTLOGIN', "ログイン情報が間違っています。");
/**#@-*/

// load plugin languages
$plugin_dir = XOOPS_ROOT_PATH . '/modules/exauth/plugins';
$dir = opendir($plugin_dir);
if ($dir) {
    while (($name = readdir($dir)) !== false) {
        if (preg_match('/^\./', $name) || !is_dir($plugin_dir.'/'.$name)) {
            continue;
        }
        $language = basename(dirname(__FILE__));
        $language_file = $plugin_dir.'/'.$name.'/language/'.$language.'/main.php';
        if (file_exists($language_file)) {
            /** @ignore */
            include_once $language_file;
        } else {
            $filename = $plugin_dir.'/'.$name.'/language/english/main.php';
            if (file_exists($filename)) {
                /** @ignore */
                include_once $filename;
            }
        }
    }
    closedir($dir);
}
