<?php
// $Id: callback2.php,v 1.2 2011/03/03 11:21:14 ohwada Exp $

//================================================================
// Facebook Module
// 2011-03-01 K.OHWADA
//================================================================

//---------------------------------------------------------
// header
//---------------------------------------------------------
include 'header.php';

//---------------------------------------------------------
// main
//---------------------------------------------------------
$REDIRECT_URL = XOOPS_URL.'/modules/facebook/index.php';
$REDIRECT_TIME_SUCCESS = 1;

if (empty($xoopsUser)) {
	facebook_callback_error( _FACEBOOK_ERR_SOMETHING .' (1)' );
	exit();
}

$uid = $xoopsUser->getVar('uid');

$service =& facebook_xoops_service::getInstance();
$exauth  =& $service->get_exauth_Instance();

$ret = $service->init();
if ( !$ret ) {
	facebook_callback_error( _FACEBOOK_ERR_SOMETHING .' (2)' );
	exit();
}

$param_callback = $service->callback( 2 );
if ( !is_array($param_callback) ) {

	$msg  = _FACEBOOK_ERR_CALLBACK ;
	$msg .= "<br />\n";
	$msg .= $service->get_error_code();
	$msg .= ' : ';
	$msg .= $service->get_error_msg();
	facebook_callback_error( $msg );
	exit();
}

$user_id = $param_callback['user_id'] ;
$token   = $param_callback['access_token'] ;

$exauth_id = $exauth->get_exauth_id( $uid );
if ( !$exauth_id ) {
	facebook_callback_error( _FACEBOOK_ERR_SOMETHING .' (3)' );
	exit();
}

if ( $user_id != $exauth_id ) {
	facebook_callback_error( _FACEBOOK_ERR_SOMETHING .' (4)' );
	exit();
}

// set token if NOT set
$token_old = $exauth->get_user_token( $uid );
if( empty($token_old) ) {
	$ret = $exauth->set_user_token( $uid, $token );
	if( !$ret ) {
		facebook_callback_error( _FACEBOOK_ERR_SOMETHING .' (6)' );
		exit();
	}
}

redirect_header( $REDIRECT_URL, $REDIRECT_TIME_SUCCESS, _FACEBOOK_LOGINED );
exit();
// === main end ===

function facebook_callback_error( $msg )
{
	$REDIRECT_URL = XOOPS_URL.'/modules/facebook/index.php';
	$REDIRECT_TIME_ERROR  = 5;

	redirect_header( $REDIRECT_URL, $REDIRECT_TIME_ERROR, $msg );
	exit();
}

?>