<?php
// $Id: exauth.class.php,v 1.1.1.1 2011/03/02 16:49:49 ohwada Exp $

//================================================================
// Facebook Module
// 2011-03-01 K.OHWADA
//================================================================

class facebook_exauth
{
	var $_db = null;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_EXAUTH_TYPE = 'facebook';

//---------------------------------------------------------
// 󥹥ȥ饯
//---------------------------------------------------------
function facebook_exauth()
{
	$this->_db =& Database::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new facebook_exauth();
	}
	return $instance;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
// exauth_id 
//---------------------------------------------------------
function get_flag_exauth_id( $uid )
{
	$flag_exauth_id = false;
	$ret = $this->get_exauth_id_param( $uid );
	if ( $ret ) {
		return true;
	}
	return false;
}

function get_exauth_id( $uid )
{
	$param = $this->get_exauth_id_param( $uid );
	if ( !isset( $param['exauth_id'] ) ) {
		return false;
	}
	return $param['exauth_id'];
}

function get_exauth_id_param( $uid )
{
	$sql =
		"SELECT " .
		"*" .
		" FROM " .
		$this->_db->prefix('exauth_id') .
		" WHERE " . "`exauth`=" . $this->_db->quoteString($this->_EXAUTH_TYPE) .
		' AND ' . '`uid`=' . intval($uid);

	$result = $this->_db->query($sql);
	if ( !$result ) {
		return false;
	}
	$numrows = $this->_db->getRowsNum($result);
	if ( $numrows != 1 ) {
		return false;
	}
	$ret = $this->_db->fetchArray($result);
	return $ret;
}

//---------------------------------------------------------
// user_token 
//---------------------------------------------------------
function get_user_token( $uid )
{
	$param = $this->get_exauth_plugin_user_value( $uid );
	if ( isset( $param['facebook_token'] ) ) {
		return  $param['facebook_token'] ;
	}
	return null;
}

function get_exauth_plugin_user_value( $uid )
{
	$arr = array();
       $sql =
       	"SELECT *" .
		" FROM " . $this->_db->prefix('exauth_plugin_user_value') .
        " WHERE " . "`uid`=" . intval($uid);
        " AND `exauth`=".$this->_db->quoteString($this->_EXAUTH_TYPE);

	$result = $this->_db->query($sql);
    if ( !$result ) {
		return false;
	}
    while ($line = $this->_db->fetchArray($result)) {
      	$arr[ $line['exauth_conf_name'] ] = $line['exauth_conf_value'] ;
    }
    return $arr;
}

//---------------------------------------------------------
// user_token ꤹ
//---------------------------------------------------------
function set_user_token( $uid, $token )
{
	$params = array(
		'facebook_token'  => $token,
	);

	return $this->set_exauth_plugin_user_value( $uid, $params );
}

function set_exauth_plugin_user_value( $uid, $params )
{
	foreach ( $params as $k => $v )
	{
		$sql =
			"INSERT INTO " .
   			$this->_db->prefix('exauth_plugin_user_value') .
   			" SET " . "`uid`=" . intval($uid) .
   			"," . "`exauth`=" . $this->_db->quoteString($this->_EXAUTH_TYPE) .
   			"," . "`exauth_conf_name`=" . $this->_db->quoteString($k) .
   			"," . "`exauth_conf_value`=" . $this->_db->quoteString($v);
		$result = $this->_db->queryF($sql);
		if ( !$result ) {
			return false;
		}
	}
	return true;
}

// === class end ===

}
?>