<?php
// $Id: service.class.php,v 1.1.1.1 2011/03/02 16:49:49 ohwada Exp $

//=========================================================
// Facebook Login
// 2011-03-01 K.OHWADA
//=========================================================

//---------------------------------------------------------
// http://developers.facebook.com/docs/reference/api/
//---------------------------------------------------------

class facebook_service
{
	var $_app_id     = null; 
	var $_app_secret = null; 

	var $_token        = null; 
	var $_url_callback = null;

	var $_scope_array = array();

	var	$_users    = array();
	var	$_pictures = array();
	var $_time_now = 0;

	var $_cache_use       = false;
	var $_cache_dir       = null;
   	var $_cache_lifetime  = 3600;
    var $_cache_errormode = null;

	var	$_elapse_full = 'Y-n-d H:i';
	var	$_elapse_hour = '%s hours ago'; 
	var	$_elapse_min  = '%s minutes ago'; 

	var $_convert_space_use = false;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_URL_DIALOG_OAUTH  = 'https://www.facebook.com/dialog/oauth';
	var $_URL_APPS          = 'http://www.facebook.com/apps/application.php';

	var $_URL_GRAPH         = 'https://graph.facebook.com/' ;
	var $_URL_GRAPH_ME      = 'https://graph.facebook.com/me' ;
	var $_URL_GRAPH_ME_HOME = 'https://graph.facebook.com/me/home';
	var $_URL_GRAPH_ME_FEED = 'https://graph.facebook.com/me/feed';
	var $_URL_GRAPH_OAUTH   = 'https://graph.facebook.com/oauth/access_token';

	var $_NAME_CODE          = 'code';
	var $_NAME_ACCESS_TOKEN  = 'access_token';
	var $_NAME_SESSION_TOKEN = 'facebook_token';

	var $_HTTP_STATUS_OK                = '200';
	var $_HTTP_STATUS_MOVED_PERMANENTLY = '301';
	var $_HTTP_STATUS_FOUND             = '302';

	var $_SEC_MIN  = 60;
	var $_SEC_HOUR = 3600;
	var $_SEC_DAY  = 86400;

	var $_STR_COMMA = ',';

function facebook_service()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new facebook_service();
	}
	return $instance;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
// login
//---------------------------------------------------------
function set_app_id( $v )
{
	$this->_app_id = $v; 
}

function set_app_secret( $v )
{
	$this->_app_secret = $v; 
}

function set_url_callback( $v )
{
	$this->_url_callback = $v; 
}

function set_scope_publish_stream( $v )
{
	if ( $v ) {
		$this->add_scope( 'publish_stream' );
	}
}

function set_scope_offline_access( $v )
{
	if ( $v ) {
		$this->add_scope( 'offline_access' );
	}
}

function add_scope( $v )
{
	$this->_scope_array[] = $v;
}

function set_scope_array( $v )
{
	if ( Is_array($v) ) {
		$this->_scope_array = $v;
	}
}

function login()
{
	$url  = $this->_URL_DIALOG_OAUTH;
	$url .= '?client_id='    . $this->_app_id;
	$url .= '&redirect_uri=' . $this->_url_callback;

	if ( is_array($this->_scope_array) && count($this->_scope_array) ) {
		$scope = implode( $this->_STR_COMMA, $this->_scope_array );
		$url .= '&scope='.$scope;
	}

	header('Location: '.$url);
	exit();
}

//---------------------------------------------------------
// callback
//---------------------------------------------------------
function callback()
{
	if ( !isset( $_GET[ $this->_NAME_CODE ] ) ) {
		$this->_error_code = 21;
		return false;
	}

	$url  = $this->_URL_GRAPH_OAUTH;
	$url .= '?client_id='     . $this->_app_id;
	$url .= '&client_secret=' . $this->_app_secret;
	$url .= '&redirect_uri='  . $this->_url_callback;
	$url .= '&code=' . $_GET[ $this->_NAME_CODE ];

	$body = $this->http_get( $url );

	if ( !$body ) {
		$this->_error_code = 22;
		return false;
	}

	parse_str( $body , $params );

	if ( !isset( $params[ $this->_NAME_ACCESS_TOKEN ] ) ) {
		$this->_error_code = 23;
		return false;
	}

	$param = array(
		'access_token' => $params[ $this->_NAME_ACCESS_TOKEN ] 
	);

	return $param;
}

//---------------------------------------------------------
// user
//---------------------------------------------------------
function set_token( $v )
{
	$this->_token = $v; 
}

function get_me()
{
	return $this->get_user( 'me' );
}

function get_user( $id )
{
	$url  = $this->_URL_GRAPH ;
	$url .= $id ;
	$url .= '?access_token='. $this->_token ;

	$user = $this->graph_get( $url, 31 );
	if ( !is_array($user) ) {
		return false;
	}

	return $user;
}

function get_picture( $id )
{
	$url  = $this->_URL_GRAPH ;
	$url .= $id ;
	$url .= '/picture';
	$url .= '?access_token='. $this->_token ;

	$picture = $this->http_location( $url );
	if ( !$picture ) {
		$this->_error_code = 41;
		return false;
	}

	return $picture;
}

function get_user_cache( $id, $flag_picture=false )
{
	if ( isset( $this->_users[ $id ] ) ) {
		return  $this->_users[ $id ];
	}

	$cache = $this->cache_get( $id );
	if ( $cache ) {
		return json_decode( $cache, true );
	}

	$user = $this->get_user( $id );
	if ( !is_array($user) ) {
		return false;
	}

	if ( $flag_picture ) {
		$user['picture'] = $this->get_picture_cache( $id );
	}

	$this->cache_save( json_encode($user), $id );

	$this->_users[ $id ] = $user;
	return $user;
}

function get_picture_cache( $id )
{
	if ( isset( $this->_pictures[ $id ] ) ) {
		return  $this->_pictures[ $id ];
	}

	$picture = $this->get_picture( $id );
	if ( !$picture ) {
		return false;
	}

	$this->_pictures[ $id ] = $picture;
	return $picture;
}

//---------------------------------------------------------
// news feeds
//---------------------------------------------------------
function get_me_feeds( $flag_user=false, $flag_picture=false )
{
	$url  = $this->_URL_GRAPH_ME_HOME ;
	$url .= '?access_token=' . $this->_token ;

	$body = $this->graph_get( $url, 51 );
	if ( !$body ) {
		return false;
	}

	$this->cache_init();

	$arr = array();
	foreach ( $body['data'] as $data ) {
		$arr[] = $this->build_each_feed( $data, $flag_user, $flag_picture );
	}

	return $arr;
}

function build_each_feed( $data, $flag_user=false, $flag_picture=false  )
{
	$id = $data['from']['id'];
	if ( $flag_user ) {
		$data['user'] = $this->get_user_cache( $id, $flag_picture );
	} elseif ( $flag_picture ) {
		$data['user']['picture'] = $this->get_picture_cache( $id );
	}
	return $data;
}

//---------------------------------------------------------
// post feed
//---------------------------------------------------------
function post_me_feed( $msg )
{
	if ( empty($msg) ) {
		$this->_error_code = 61;
		return false;
	}

	$url  = $this->_URL_GRAPH_ME_FEED ;
	$url .= '?access_token=' . $this->_token ;
	$url .= '&message=' . urlencode($msg);

	$ret = $this->http_post( $url );
	if ( !$ret ) {
		$this->_error_code = 62;
		return false;
	}

	return true;
}

//---------------------------------------------------------
// http
//---------------------------------------------------------
function graph_get( $url, $err )
{
	$body = $this->http_get( $url );
	if ( !$body ) {
		$this->_error_code = $err;
		return false;
	}

	$param = json_decode( $body, true );
	return $param;
}

function http_get( $url )
{
	$request = new HTTP_Request2($url, HTTP_Request2::METHOD_GET);
	$request->setConfig(array(
		'ssl_verify_peer' => false
	));
	$response = $request->send();

	if ( $response->getStatus() <> $this->_HTTP_STATUS_OK ) {
		$this->_error_msg  = $response->getReasonPhrase() ;
		return false;
	}

	return $response->getBody();
}

function http_post( $url )
{
	$request = new HTTP_Request2($url, HTTP_Request2::METHOD_POST);
	$request->setConfig(array(
		'ssl_verify_peer' => false
	));
	$response = $request->send();

	if ( $response->getStatus() <> $this->_HTTP_STATUS_OK ) {
		$this->_error_msg  = $response->getReasonPhrase() ;
		return false;
	}

	return true;
}

function http_location( $url )
{
	$request = new HTTP_Request2($url, HTTP_Request2::METHOD_GET);
	$request->setConfig(array(
		'ssl_verify_peer' => false
	));

	$response = $request->send();
	$status   = $response->getStatus();

	if (( $status <> $this->_HTTP_STATUS_MOVED_PERMANENTLY ) &&
	    ( $status <> $this->_HTTP_STATUS_FOUND )) {
		$this->_error_msg  = $response->getReasonPhrase() ;
		return false;
	}

	$header = $response->getHeader();
	if ( isset( $header['location'] ) ) {
		return  $header['location'];
	}

	$this->_error_msg  = 'no header location' ;
	return false;
}

//---------------------------------------------------------
// feed utitity
//---------------------------------------------------------
function set_elapse_full( $v )
{
	$this->_elapse_full = $v;
}

function set_elapse_hour( $v )
{
	$this->_elapse_hour = $v; 
}

function set_elapse_min( $v )
{
	$this->_elapse_min = $v; 
}

function set_convert_space_use( $v )
{
	$this->_convert_space_use =  (bool)$v; 
}

function feeds_to_array( $feeds )
{
	$arr = array();
	foreach ( $feeds as $feed )
	{
		$t = array();
		foreach ( $feed as $k1 => $v1 )
		{
			if ( is_array($v1) ) {
				foreach ( $v1 as $k2 => $v2 ) {
					$t[ $k1.'_'.$k2 ] = $v2;
				}
			} else {
				$t[ $k1 ] = $v1;
			}
		}
		$arr[] = $t;
	}
	return $arr;
}

function convert_feeds( $feeds )
{
	$this->_time_now = time();

	if ( $this->_convert_space_use ) {
		$orig = $this->get_internal_encoding();
		$this->set_internal_encoding( 'UTF-8', $orig );
	}

	$arr = array();
	foreach ( $feeds as $feed )
	{
		$feed['message_convert']  = $this->build_message_from_feed(  $feed );
		$feed['application_link'] = $this->build_app_link_from_feed( $feed );
		$feed['time_elapse']      = $this->build_elapse_from_feed(   $feed );

		$arr[] = $feed;
	}

	if ( $this->_convert_space_use ) {
		$current = $this->get_internal_encoding();
		$this->set_internal_encoding( $orig, $current );
	}

	return $arr;
}

function get_array_value_by_key( $arr, $key )
{
	if ( isset( $arr[ $key ] ) ) {
		return  $arr[ $key ];
	}
	return null;
}

function build_app_link_from_feed( $feed )
{
	$id   = $this->get_array_value_by_key( $feed, 'application_id' );
	$name = $this->get_array_value_by_key( $feed, 'application_name' );

	return $this->build_app_link( $id, $name );
}

function build_app_link( $id, $name )
{
	$link  = '';
	$href  = '';
	$begin = '';
	$end   = '';

	if ( $id ) {
		$href  = $this->_URL_APPS;
		$href .= '?id='. $id;
		$begin = '<a href="'. $href .'" target="_blank">'."\n";
		$end   = '</a>'."\n";
	}
	if ( $name ) {
		$link  = $begin;
		$link .= $name;
		$link .= $end;
	}

	return $link;
}

function build_elapse_from_feed( $feed )
{
	$time = $this->get_array_value_by_key( $feed, 'created_time' );
	return $this->build_elapse( $time );
}

function build_elapse( $time )
{
	if ( empty($time) ) {
		return '';
	}

	$unix = strtotime( $time );
	if ( empty($unix) ) {
		return '';
	}

	return $this->build_elapse_fomated( $unix );
}

function build_elapse_fomated( $unix )
{
	if ( $unix <= 0 ) {
		return '';
	}

	$total = $this->_time_now - $unix ;

	$day = intval( $total / $this->_SEC_DAY );
	$remainder = $total - ( $day * $this->_SEC_DAY );

	$hour = intval( $remainder / $this->_SEC_HOUR );
	$remainder = $remainder - ( $hour * $this->_SEC_HOUR );

	$min = intval( $remainder / $this->_SEC_MIN );
	$sec = $remainder - ( $min * $this->_SEC_MIN );

	if ( $day > 0 ) {
		$str = date( $this->_elapse_full, $unix ); 

	} elseif ( $hour > 0 ) {
		$str  = sprintf( $this->_elapse_hour, $hour );

	} else {
		if ( $min == 0 ) {
			 $min = 1;
		}
		$str  = sprintf( $this->_elapse_min, $min ); 
	}

	return $str;
}

function build_message_from_feed( $feed )
{
	$msg = $this->get_array_value_by_key( $feed, 'message' );
	return $this->build_message( $msg );
}

function build_message( $str )
{
	if ( empty($str) ) {
		return '';
	}

	if ( $this->_convert_space_use ) {
		$str = $this->convert_space_zen_to_han( $str );
	}

	$str = $this->make_clickable_http( $str );
	$str = $this->make_clickable_tag(  $str );
	return $str;
}

function make_clickable_tag( $str )
{
	$p   = array();
	$r   = array();
	$p[] = '/@(\w+)/';
	$r[] = '<a href="http://twitter.com/\\1" target="_blank">@\\1</a>';
	$p[] = '/#(\w+)/';
	$r[] = '<a href="http://twitter.com/#search?q=%23\\1" target="_blank">#\\1</a>';

	$str = preg_replace( $p, $r, $str );
	return $str;
}

// reference: XOOPS module.textsanitizer.php
function make_clickable_http( $str )
{
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])([a-z]+?):\/\/([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])www\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])ftp\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/:\.])([a-z0-9\-_\.]+?)@([^, \r\n\"\(\)'<>\[\]]+)/i";

	$r[] = "\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>";
	$r[] = "\\1<a href=\"http://www.\\2.\\3\" target=\"_blank\">www.\\2.\\3</a>";
	$r[] = "\\1<a href=\"ftp://ftp.\\2.\\3\" target=\"_blank\">ftp.\\2.\\3</a>";
	$r[] = "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>";

	$str = preg_replace( $p, $r, $str );
	return $str;
}

//---------------------------------------------------------
// session
//---------------------------------------------------------
function set_name_session_token( $v )
{
	$this->_NAME_SESSION_TOKEN = $v; 
}

function set_session_token( $token )
{
	$_SESSION[ $this->_NAME_SESSION_TOKEN ] = $token;
}

function clear_session_token()
{
	unset( $_SESSION[ $this->_NAME_SESSION_TOKEN ] );
}

function get_session_token()
{
	if ( isset( $_SESSION[ $this->_NAME_SESSION_TOKEN ] ) ) {
		return  $_SESSION[ $this->_NAME_SESSION_TOKEN ];
	}
	return false;
}

function isset_session_token()
{
	if ( isset( $_SESSION[ $this->_NAME_SESSION_TOKEN ] ) ) {
		return true;
	}
	return false;
}

//---------------------------------------------------------
// encoding
//---------------------------------------------------------
function get_internal_encoding()
{
	if ( function_exists('mb_internal_encoding') ) {
		return mb_internal_encoding();
	}
	return false;
}

function set_internal_encoding( $charset, $current=null )
{
	if ( function_exists('mb_internal_encoding') ) {
		if ( $current ) {
			$current = mb_internal_encoding();
		}
		if ( strtolower($current) == strtolower($charset) ) {
			return true;
		}
		$ret = mb_internal_encoding( $charset );
		if ( $ret === false ) {
			mb_internal_encoding( $current );
		}
		return $ret;
	}
	return true;	// dummy
}

function convert_space_zen_to_han( $str )
{
	if ( function_exists('mb_convert_kana') ) {
		return mb_convert_kana( $str, 's' );
	}
	return $str;
}

function convert_feeds_encoding( $feeds, $to )
{
	$arr = array();
	foreach ( $feeds as $feed ) {
		$t = array();
		foreach ( $feed as $k => $v ) {
			$t[ $k ] = $this->convert_from_utf8( $v, $to );
		}
		$arr[] = $t;
	}
	return $arr;
}

function convert_from_utf8( $str, $to )
{
	return $this->convert_encoding( $str, 'UTF-8', $to );
}

function convert_to_utf8( $str, $from )
{
	return $this->convert_encoding( $str, $from, 'UTF-8' );
}

function convert_encoding( $str, $from, $to, $extra='//IGNORE' )
{
	if ( strtolower($to) == strtolower($from) ) {
		return $str;
	}
	if ( is_array($str) ) {
		return $str;
	}
	if ( function_exists('iconv') ) {
		return iconv( $from, $to.$extra , $str );
	}
	if ( function_exists('mb_convert_encoding') ) {
		return mb_convert_encoding( $str, $from, $to );
	}
	return $str;
}

//---------------------------------------------------------
// cache
//---------------------------------------------------------
function set_cache_use( $v )
{
	$this->_cache_use = (bool)$v; 
}

function set_cache_dir( $v )
{
	$this->_cache_dir = $v; 
}

function set_cache_lifetime( $v )
{
	$this->_cache_lifetime = intval($v); 
}

function set_cache_errormode( $v )
{
	$this->_cache_errormode = intval($v); 
}

function cache_init()
{
	if ( !$this->_cache_use ) {
		return false;
	}

	$options = array(
   		'cacheDir'      => $this->_cache_dir,
   		'lifeTime'      => $this->_cache_lifetime,
	);

	if ( $this->_cache_errormode ) {
		$options['pearErrorMode'] = $this->_cache_errormode;
	}

	$this->_cache = new Cache_Lite($options);
	return true;
}

function cache_save( $data, $id=null, $group='default' )
{
	if ( !$this->_cache_use ) {
		return false;
	}

	return $this->_cache->save( $data, $id, $group );
}

function cache_get( $id, $group='default', $doNotTestCacheValidity=false )
{
	if ( !$this->_cache_use ) {
		return false;
	}

    return $this->_cache->get( $id, $group, $doNotTestCacheValidity );
}

// === class end ===
}
?>