<?php
// $Id: Common.class.php,v 1.4 2011/03/25 02:49:56 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauth_Common
{
	// コンポーネント
	var $_container   = null;
	var $_session     = null;
	var $_commonMain  = null;
	var $_configView  = null;
	var $_usersView   = null;
	var $_modulesView = null;

	// セットされる変数
	var	$_dirname      = null;
	var $_module_id    = null;
	var $_item_name_id = null;
	var $_lang_err_someting = null ;

	// ローカル変数
	var $_error_code = array();
	var $_error_msg  = array();
	var	$_error_msg_admin = array();
	var $_exauthadmin_config_array = null ;

	// 定数
	var $_REDIRECT_TIME_SERVER  = 1;	// 1 sec
	var $_REDIRECT_TIME_SUCCESS = 1;	// 1 sec
	var $_REDIRECT_TIME_ERROR   = 5;	// 5 sec
	var $_SESSION_NAME_AUTH     = 'exauth_auth';
	var $_SESSION_NAME_REDIRECT = 'exauth_redirect';
	var $_SESSION_NAME_POST     = 'exauth_post';
	var $_DIRNAME_EXAUTHADMIN   = 'exauthadmin';
	var $_OPTION_PREFIX         = '_opt_';

	var $_TEMPLATE_DIR_EXAUTH = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Common() 
	{
		$this->init_dicontainer('common.dicon.ini');
		$this->init_component_common();
		$this->init_smarty_assign('common.maple.ini');

		$this->_TEMPLATE_DIR_EXAUTH = WEBAPP_DIR . '/templates/exauth/';
	}

    function set_dirname( $dirname )
	{
		$this->_dirname = strtolower( $dirname );
	}

	function set_module_id( $v )
	{
		$this->_module_id = intval($v);
	}

    function set_item_name_id( $v )
	{
		$this->_item_name_id = $v;
	}

    function init_module_id()
	{
		$this->set_module_id(
			$this->get_module_id_by_dirname( $this->_dirname ) );
	}

    function init_item_name_id()
	{
		$this->set_item_name_id(
			$this->get_module_item_name_id() );
	}

//---------------------------------------------------------
// コンポーネントの初期化
//---------------------------------------------------------
    function init_component_common()
    {
		$this->_commonMain  =& $this->_container->getComponent("commonMain");
		$this->_session     =& $this->_container->getComponent("Session");
		$this->_configView  =& $this->_container->getComponent("configView");
		$this->_modulesView =& $this->_container->getComponent("modulesView");
		$this->_usersView   =& $this->_container->getComponent("usersView");
	}

//---------------------------------------------------------
// エラーメッセージ
//---------------------------------------------------------
	function get_error_msg()
	{
		$code  = $this->get_error_code( true );
		$error = $this->get_error_msg_raw( true );
		if ( empty($error) && $code ) {
			$error = $this->_lang_err_someting .' ('.$code.')';
		}
		return $error;
	}

	function get_error_code( $flag=false ) 
	{
		if ( $flag && is_array($this->_error_code) ) {
			if ( count($this->_error_code) == 0 ) {
				return 0;
			} else {
				return $this->_error_code[0];
			}
		}
		return $this->_error_code;
	}

	function get_error_msg_raw( $flag=false ) 
	{
		if ( $flag && is_array($this->_error_msg) ) {
			if ( count($this->_error_msg) == 0 ) {
				return null;
			}
			if ( count($this->_error_msg) == 1 ) {
				return $this->_error_msg[0];
			}
			return implode( "<br />\n", $this->_error_msg );
		}
		return $this->_error_msg ;
	}

	function set_error_code( $code ) 
	{
		$this->_error_code[] = $code;
	}

	function set_error_msg( $msg ) 
	{
		$this->_error_msg[] = $msg ;
	}

	function set_error_msg_single( $msg ) 
	{
		$this->_error_msg = array( $msg );
	}

	function set_error_admin( $msg ) 
	{
		$this->_error_msg_admin[] = $msg ;
	}

//---------------------------------------------------------
// DI Container の初期化
// Controller::_createDIContainer()
//---------------------------------------------------------
    function init_dicontainer( $file )
    {
		$this->_container =& DIContainerFactory::getContainer();

		$config = $this->parse_exauth_config_file( $file ) ;
        if ( !$config ) {
            return false;
        }

        foreach ($config as $key => $value) 
		{
			$className = '';
			$filename  = '';

            if (isset($config[$key]["name"])) {
                $className = $config[$key]["name"];
            }
            if (isset($config[$key]["path"])) {
                $filename = BASE_DIR .'/'. $config[$key]["path"];
            }

            if (!$className || !$filename) {
            	return false;
            }

			$component =& $this->_container->getComponent($key);
			if ( is_object($component) ) {
				continue;
			}

            include_once($filename);

            $instance =& new $className();

            if (!is_object($instance)) {
            	return false;
            }

            $this->_container->register($instance, $key);
        }

		return true;
	}

	function parse_exauth_config_file( $file )
	{
		$filename = WEBAPP_DIR.'/components/exauth/'.$file ;
		return $this->parse_config_file( $filename, true );
	}

//---------------------------------------------------------
// PHP 定数の初期化
// Filter_SmartyAssign::_setLang()
//---------------------------------------------------------
    function init_smarty_assign( $file )
	{
		$initializer =& DIContainerInitializerLocal::getInstance();

    	$lang = $this->_session->getParameter("_lang");
		$global_filepath      = WEBAPP_DIR . "/language/" . $lang . "/";
		$global_conf_filepath = WEBAPP_DIR . "/config/";

		$filenames = array();

		$config = $this->parse_exauth_config_file( $file ) ;
		if ( !isset( $config["SmartyAssign"] ) ) {
            return false;
		}

		$attributes = $config["SmartyAssign"];

		if (isset($attributes["global"])) {
			$commonArray = explode(",", $attributes["global"]);
			foreach ($commonArray as $key => $value) {
				$commonArray[$key] = trim($value);
				$filenames[] = $global_filepath . $commonArray[$key];
			}
		}

		if (isset( $attributes["global_config"]) ) {
			$moduleArray = explode( ",", $attributes["global_config"] );
			foreach ($moduleArray as $key => $value) {
				$filenames[] = $global_conf_filepath.$moduleArray[$key];
			}
		}

		foreach ( $filenames as $filename )
		{
			$tmp_lang_arr = $initializer->read_ini_file($filename, true);

			if ( isset( $tmp_lang_arr["Define"] )) {
				foreach ( $tmp_lang_arr["Define"] as $key => $value ) {
					if ( !defined($key) ) {
						define($key, $value);
					}
				}
			}
		}
	}

//---------------------------------------------------------
// 言語定数
//---------------------------------------------------------
	function set_lang_common() 
	{
		$this->_lang_err_someting = EXAUTH_ERR_SOMETING ;
	}

    function set_lang( $dirname, $langname )
	{
		$name1 = $dirname.'_'.$langname;
		$name2 = '_lang_'.$langname;
		$value = $this->get_constant( $name1 );
		if ( $value && isset( $this->$name2 ) ) {
			$this->$name2 = $value;
		}
	}

    function get_constant( $name )
	{
		$name = strtoupper( $name );
		if ( defined($name) ) {
			return constant($name);
		}
		return false;
	}

//---------------------------------------------------------
// configView
//---------------------------------------------------------
    function get_config_enter_exit_by_key( $key )
	{
		$config = $this->get_config_enter_exit();
		$val    = $this->get_config_value_by_key( $config, $key );
		return $val;
	}

    function get_config_general()
	{
       	$config = $this->_configView->getConfigByCatid(
			_SYS_CONF_MODID, _GENERAL_CONF_CATID);
		return $config;
	}

    function get_config_enter_exit()
    {
    	$config = $this->_configView->getConfigByCatid(
			_SYS_CONF_MODID, _ENTER_EXIT_CONF_CATID);
		return $config;
	}

	function get_module_config_mode_register( $module_id )
	{
		return $this->get_module_config_by_key( $module_id, 'mode_register' );
	}

	function get_module_config_by_key( $module_id, $key )
	{
        $config = $this->get_module_config( $module_id );
		$val    = $this->get_config_value_by_key( $config, $key );
		return $val;
	}

	function get_module_config( $module_id, $catid_as_key=false )
	{
        $config = $this->_configView->getConfig( $module_id, $catid_as_key );
		return $config;
	}

	function get_config_value_by_key( $config, $key )
	{
		$val = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

//---------------------------------------------------------
// modulesView
//---------------------------------------------------------
	function get_module_id_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return $module['module_id'];	
		}
		return false;
	}

	function module_installed_by_dirname( $dirname )
	{
		if ( $this->get_module_id_by_dirname( $dirname ) ) {
			return true;
		}
		return false;
	}

//---------------------------------------------------------
// usersView
//---------------------------------------------------------
	function get_item_id_by_name( $name )
	{
		$item_params = array(
			'item_name' => $name
		);

		$items = $this->_usersView->getItems( $item_params );

		$item_id = 0;
		if ( isset($items[0]['item_id']) ) {
			$item_id = $items[0]['item_id'];
		}

		if ( empty($item_id) ) {
			return false;
		}

		return $item_id;
	}

//---------------------------------------------------------
// GET POST 
//---------------------------------------------------------
	function get_get_by_key( $key )
	{
		$str = isset($_GET[$key]) ? $_GET[$key] : null;
		return $str;
	}

	function get_post_by_key( $key )
	{
		$str = isset($_POST[$key]) ? $_POST[$key] : null;
		return $str;
	}

//---------------------------------------------------------
// SERVER 変数を取得する
//---------------------------------------------------------
	function is_server_https_on() 
	{
		if ( strtolower( $this->get_server_https() ) == 'on' ) {
			return true;
		}
		return false;
	}

	function get_server_https() 
	{
		return $this->get_server_by_key( 'HTTPS' );
	}

	function get_server_http_referer() 
	{
		return $this->get_server_by_key( 'HTTP_REFERER' );
	}

	function get_server_by_key( $key ) 
	{
		$str = isset($_SERVER[ $key ]) ? $_SERVER[ $key ] : null ;
		return $str;
	}

//---------------------------------------------------------
// session 
//---------------------------------------------------------
    function get_session_auth()
    {
		return $this->_session->getParameter( 
			$this->_SESSION_NAME_AUTH );
	}

    function set_session_auth( $v )
    {
		$this->_session->setParameter( 
			$this->_SESSION_NAME_AUTH, $v );
	}

    function get_session_redirect()
    {
		return $this->_session->getParameter( 
			$this->_SESSION_NAME_REDIRECT );
	}

    function set_session_redirect( $v )
    {
		$this->_session->setParameter( 
			$this->_SESSION_NAME_REDIRECT, $v );
	}

    function get_session_post()
    {
		return $this->_session->getParameter( 
			$this->_SESSION_NAME_POST );
	}

    function set_session_post( $v )
    {
		$this->_session->setParameter( 
			$this->_SESSION_NAME_POST, $v );
	}

//---------------------------------------------------------
// token 
//---------------------------------------------------------
	function get_token_value()
	{
		require_once MAPLE_DIR.'/nccore/TokenExtra.class.php';

		$token =& new TokenExtra();
		$token->setSession( $this->_session );
		$token->build();
		return $token->getValue();
	}

	function check_token()
	{
		require_once MAPLE_DIR.'/nccore/TokenExtra.class.php';

		$request =& $this->_container->getComponent("Request");

		$token =& new TokenExtra();
		$token->setSession( $this->_session );
		return $token->check( $request );
	}

//---------------------------------------------------------
// redirect 
//---------------------------------------------------------
    function redirect_success( $url, $msg )
    {
		$this->_commonMain->redirectHeader( 
			$url , 
			$this->_REDIRECT_TIME_SUCCESS, 
			$msg );
		exit();
	}

    function redirect_error( $url, $msg )
    {
		$this->_commonMain->redirectHeader( 
			$url, 
			$this->_REDIRECT_TIME_ERROR, 
			$msg );
		exit();
	}

    function redirect_server( $url, $msg )
    {
		$this->_commonMain->redirectHeader( 
			$url, 
			$this->_REDIRECT_TIME_SERVER, 
			$msg );
		exit();
	}

//---------------------------------------------------------
// リダイレクト先を取得する
//---------------------------------------------------------
    function get_redirect_url( $flag_admin=false )
    {
// セッションのリダイレクトURL を取得する
		$url = $this->get_session_redirect();

// リダイレクトURL がなければ、デフォルトへ
		if ( empty($url )) {

// ログイン中ならば、管理画面に
			if ( $flag_admin ) {
				$url = BASE_URL.'/index.php?action=control_view_main';

// そうでなければ、トップ管理画面に
			} else {
				$url = BASE_URL.'/';
			}
		}

		return $url;
	}

//---------------------------------------------------------
// ベースのURLを取得する
//---------------------------------------------------------
	function get_base_url() 
	{
		if ( ( CORE_BASE_URL == BASE_URL ) && 
			$this->is_server_https_on() ) {
			$url = BASE_URL_HTTPS;
		} else {
			$url = CORE_BASE_URL;
		}
		return $url;
	}

//---------------------------------------------------------
// cookie 
// 未使用
//---------------------------------------------------------
	function set_cookie( $key, $value, $time=3600 )
	{
		$path   = ini_get("session.cookie_path");
		$domain = ini_get("session.cookie_domain");
		$secure = ini_get("session.cookie_secure");

		$lifetime = time() + $time;

		setcookie( $key, $value, $lifetime, $path, $domain, $secure );
	}

	function get_cookie( $key )
	{
		$str = isset($_COOKIE[ $key ]) ? $_COOKIE[ $key ] : null;
		return $str;
	}

//---------------------------------------------------------
// templates
//---------------------------------------------------------
	function clear_compiled_tpl_in_exauth()
	{
 		$this->clear_compiled_tpl_in_dir( 
			$this->_TEMPLATE_DIR_EXAUTH );
	}

	function clear_compiled_tpl_in_module()
	{
		$dir = $this->get_module_template_main_dir();
		if ( !is_dir($dir) ) {
			return false;
		}

		$this->clear_compiled_tpl_in_dir( $dir );
		return true;
	}

	function clear_compiled_tpl_in_dir( $dir )
	{
		$files = $this->get_files_in_dir( $dir, 'html' );
 		$this->clear_compiled_tpl( $dir, $files );
	}

	function clear_compiled_tpl( $dir, $files )
	{
		$renderer =& SmartyTemplate::getInstance();
		$renderer->setTemplateDir( $dir );
		foreach ( $files as $file ) {
			$renderer->clear_compiled_tpl( $file );
		}
		return true;
	}

	function get_files_in_dir( $path, $ext=null, $flag_dir=false, $flag_sort=false, $id_as_key=false  )
	{
		$arr = array();

		$lists = $this->get_lists_in_dir( $path );
		if ( !is_array($lists) ) {
			return false;
		}

		$pattern = "/\.". preg_quote($ext) ."$/";

		foreach ( $lists as $list ) 
		{
			$path_list = $path .'/'. $list;

// check is file
			if ( is_dir($path_list) || !is_file($path_list) ) {
				continue;
			}

// check ext
			if ( $ext && !preg_match($pattern, $list) ) {
				continue;
			}

			$arr[] = $list;
		}

		return $arr;
	}

	function get_lists_in_dir( $path )
	{
		$arr = array();

// check is dir
		if ( !is_dir($path) ) {
			return false;
		}

// open
		$dh = opendir($path);
		if ( !$dh ) {
			return false;
		}

// read
		while ( false !== ($list = readdir( $dh )) ) {
			$arr[] = $list;
		}

// close
		closedir( $dh );
		return $arr;
	}

//---------------------------------------------------------
// オプションの設定
//---------------------------------------------------------
    function init_module_option( $file='option.ini', $process_sections=false )
    {
        $config = $this->get_module_option_config( $file, $process_sections );
        if ( !$config ) {
            return false;
        }

        foreach ($config as $key => $value) 
		{
			$name = $this->_OPTION_PREFIX.$key;
			if ( isset($this->$name) ) {
				$this->$name = $value;
			}
		}
	}

    function get_module_option_config_by_key( $key )
    {
		$config = $this->get_module_option_config();
		if ( isset( $config[ $key ] ) ) {
			return  $config[ $key ] ;
		}
		return false;
	}

    function get_module_option_config( $file='option.ini', $process_sections=false )
    {
		$filename = $this->get_module_config_option_file( $file );
		return $this->parse_config_file( $filename, $process_sections );
	}

	function parse_config_file( $filename, $process_sections=false )
	{
        if ( !file_exists($filename) ) {
            return false;
        }

        $config = parse_ini_file( $filename, $process_sections );
        if ( !is_array($config) || !count($config) ) {
            return false;
        }

		return $config;
	}

//---------------------------------------------------------
// モジュール定数
//---------------------------------------------------------
	function get_module_item_name_list()
	{
		$name = $this->_dirname.'_ITEM_NAME_LIST';
		$list = $this->get_constant( $name );
		if ( empty($list) ) {
			return false;
		}

		return explode( '|', $list );
	}

    function get_module_item_name_id()
	{
		$name = $this->_dirname.'_ITEM_NAME_ID';
		return $this->get_constant( $name );
	}

	function get_module_template_main_dir($flag=true )
	{
		$str = WEBAPP_DIR . '/modules/'. $this->_dirname .'/templates/main';
		if ( $flag ) {
			$str .= '/';
		}
		return $str;
	}

	function get_module_config_option_file( $file )
	{
		$str = WEBAPP_DIR . '/modules/'. $this->_dirname .'/config/'.$file;
		return $str;
	}

	function get_module_uploads_dir( $flag=true )
	{
		$str = WEBAPP_DIR .'/uploads/'. $this->_dirname ;
		if ( $flag ) {
			$str .= '/';
		}
		return $str;
	}

//---------------------------------------------------------
// 外部認証のときの処理
//---------------------------------------------------------
	function build_user_item_require_flag( $item )
	{
		$tag_name     = $item['tag_name'] ;
		$require_flag = 0;

		switch ( $tag_name )
		{
			case 'login_id':
				$require_flag = 1;
				break;

			case 'handle':
			case 'email':
				if ( $this->get_allow_config( $tag_name ) == 2 ) {
					$require_flag = 1;
				}
				break;
		}

		$item['require_flag'] = $require_flag;
		return $item;
	}

	function init_exauthadmin_config()
	{
		$module_id = $this->get_module_id_by_dirname( $this->_DIRNAME_EXAUTHADMIN );

        $config = $this->get_module_config( $module_id );
		$arr = array();
		foreach ( $config as $key => $value ) {
			$arr[ $key ] = $this->get_config_value_by_key( $config, $key );
		}
		$this->_exauthadmin_config_array = $arr;
	}

	function get_exauthadmin_config( $key )
	{
		if ( isset( $this->_exauthadmin_config_array[ $key ] )) {
			return  $this->_exauthadmin_config_array[ $key ];
		}
		return false;
	}

	function get_allow_config( $key )
	{
		return $this->get_exauthadmin_config( 'mode_'.$key );
	}

// === class end ===
}

?>