<?php
// $Id: Action.class.php,v 1.2 2011/03/16 14:24:21 ohwada Exp $

//=========================================================
// Exauthadmin Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// execute()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauthadmin_Components_Action
{
    // コンポーネント
	var $_container     = null;
	var $_modulesView   = null;

    /**
     * DB登録
     *
     * @access  public
     */
    function Exauthadmin_Components_Action()
    {
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_modulesView =& $this->_container->getComponent("modulesView");
    }

    function execute( $dirname )
    {
	    $flag = $this->module_installed_by_dirname( $dirname );
    	if ( !$flag ) {
			return 'error';	
		}
		$this->action_by_dirname( $dirname );
    	return 'success';
    }

    function module_installed_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return true;	
		}
		return false;
	}

	function action_by_dirname( $dirname )
	{
		$file = BASE_DIR.'/webapp/modules/'.$dirname.'/components/Admin.class.php' ;
		$class = ucfirst($dirname).'_Components_Admin';

		if ( !file_exists($file) ) {
			return false;
		}

		include_once $file;

		if ( !class_exists($class) ) {
			return false;
		}

		$admin = new $class;
		$admin->action();
	}

// ===class end ===
}
?>