<?php
// $Id: Validator_GooglesearchCount.class.php,v 1.1.1.1 2009/03/31 10:21:34 ohwada Exp $

//=========================================================
// Googlesearch Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlesearch件数チェックバリデータクラス
 *
 * @package     NetCommons.validator
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlesearch_Validator_GooglesearchCount extends Validator
{
    /**
     * Googlesearch件数チェックバリデータ
     *
     * @param   mixed   $attributes チェックする値
     * @param   string  $errStr     エラー文字列
     * @param   array   $params     オプション引数
     * @return  string  エラー文字列(エラーの場合)
     * @access  public
     */
    function validate($attributes, $errStr, $params)
    {
// スクロール中は不要
		if ($attributes["scroll"] == _ON) {
			return;
		}

// partsレコード件数の取得
		$container =& DIContainerFactory::getContainer();
        $googlesearchView =& $container->getComponent("googlesearchView");
		$googlesearchCount = $googlesearchView->getGooglesearchCount();
        if ($googlesearchCount == 0) {
        	return $errStr;
        }

		$request =& $container->getComponent("Request");
		$request->setParameter("googlesearchCount", $googlesearchCount);
		
        return;
    }
}
?>