<?php
// $Id: Action.class.php,v 1.3 2011/03/19 15:55:18 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// Common.class.php
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;
include_once BASE_DIR.'/webapp/components/exauth/Form.class.php' ;
include_once BASE_DIR.'/webapp/components/exauth/Login.class.php' ;
include_once BASE_DIR.'/webapp/components/exauth/Register.class.php' ;

class Exauth_Action extends Exauth_Common
{
    // コンポーネント
	var $_usersAction   = null;
	var $_login         = null;
	var $_register      = null;
	var $_form          = null;

	// セットされる変数
	var $_item_name_array = null;
	var $_item_name_id    = null;

	// 言語変数
	var $_lang_logined    = null ;
	var $_lang_id_changed = null ;
	var $_lang_registered = null ;
	var $_lang_claered    = null ;
	var $_lang_err_id_already = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Action() 
	{
		$this->Exauth_Common();

		$this->init_dicontainer('action.dicon.ini');
		$this->init_component_common();
		$this->init_component();
//		$this->init_smarty_assign('action.maple.ini');
	}

    function set_dirname_action( $dirname )
	{
		$this->set_dirname( $dirname );

		$this->set_lang_common();
		$this->set_lang_action();
		$this->set_lang_by_dirname( $dirname );

		$this->_form->set_dirname_form( $dirname );
		$this->_login->set_dirname_login( $dirname );
		$this->_register->set_dirname_register( $dirname );

		$this->init_item_name_array();
	}

	function set_lang_action() 
	{
		$this->_lang_logined     = EXAUTH_LOGINED;
		$this->_lang_id_changed  = EXAUTH_ID_CHANGED;
		$this->_lang_registered  = EXAUTH_REGISTERED;
		$this->_lang_cleared     = EXAUTH_CLEARED;
		$this->_lang_err_id_already = EXAUTH_ERR_ID_ALREADY;
	}

    function set_lang_by_dirname( $dirname )
	{
		$this->set_lang( $dirname, 'id_changed' );
		$this->set_lang( $dirname, 'err_id_already' );
	}

    function init_component()
    {
		$this->_usersAction =& $this->_container->getComponent("usersAction");

		$this->_login    = new Exauth_Login();
		$this->_register = new Exauth_Register();
		$this->_form     = new Exauth_Form();
	}

    function init_item_name_array()
	{
		$items = $this->get_module_item_name_list();
		$this->set_item_name_array( $items );
	}

    function set_item_name_array( $v )
	{
		if ( is_array($v) ) {
			$this->_item_name_array = $v;
			if ( isset( $v[0] ) ) {
				$this->set_item_name_id( $v[0] );
			}
		}
	}

//---------------------------------------------------------
// ログイン認証を行う
// action: login
//---------------------------------------------------------
    function execute_login()
    {

// 既にログイン済であれば、リダイレクト
       	if ( $this->_session->getParameter("_user_id") ) {
			header("Location: ". BASE_URL.'/' );
			exit();
		}

		$param_input = array(
			'login_id'     => $this->get_post_by_key('login_id') ,
			'password'     => $this->get_post_by_key('password') ,
			'redirect_url' => $this->get_session_redirect() ,
		);

		$code         = $this->_login->login_by_param( $param_input );
		$msg          = $this->_login->get_error_msg();
		$redirect_url = $this->_login->get_login_redirect_url();
		$user_id      = $this->_login->get_user_id();

		switch ( $code )
		{
			case 0:
				break;

			case -1:
				$this->_form->display_login_form( $param_input, $msg );
				exit();

			case -2:
				$this->redirect_error( 
					$this->get_redirect_url(), 
					$msg );
				exit();	

			default:
				$this->redirect_error( 
					$this->get_redirect_url(), 
					$this->_lang_err_someting.' (10)' );
				exit();
		}

// 認証パラメータを取得
		$param = unserialize( $this->get_session_auth() );

// 認証パラメータがなければ、エラー表示
		if ( !$this->check_auth_param($param) ) {
			$msg = $this->_lang_err_someting.' (5)';
			$this->redirect_error( 
				$this->get_redirect_url(), 
				$this->msg ); 
			exit();
		}

// すでに関連付けされていれば、選択画面を表示する
		$auth_id_old = $this->get_authid_by_userid( $user_id );
		if ( $auth_id_old ) {
			$auth_id = $this->get_auth_id( $param );
			$this->_form->display_select_form( $auth_id, $auth_id_old );
			exit();
		}

// 認証パラメータ を保存する
		$this->save_auth_or_redirect( $user_id, $param ); 

// 成功
		$this->redirect_success( 
			$redirect_url ,
			$this->_lang_logined );
		exit();
	}

//---------------------------------------------------------
// ユーザ登録を行う
// action: register
//---------------------------------------------------------
    function execute_register()
    {

// 既にログイン済であれば、リダイレクト
       	if ( $this->_session->getParameter("_user_id") ) {
			header("Location: ". BASE_URL.'/' );
			exit();
		}

		$items = $this->get_post_by_key('items');
		$items = $this->_register->build_exauth_items( $items );

		$param0 = null;
		$param_input = array(
			'items'                    => $items ,
			'items_public'             => $this->get_post_by_key('items_public'),
			'items_reception'          => $this->get_post_by_key('items_reception'),
			'items_password_confirm'   => $this->get_post_by_key('items_password_confirm'),
			'autoregist_disclaimer_ok' => $this->get_post_by_key('autoregist_disclaimer_ok'),
			'autoregist_input_key'     => $this->get_post_by_key('autoregist_input_key'),
			'param0'                   => $param0,
		);

		$code    = $this->_register->register( $param_input );
		$msg     = $this->_register->get_error_msg();
		$user_id = $this->_register->get_user_id();

		switch ( $code )
		{
			case 0:
				break;

			case -1:
				$this->_form->register_display_register_form( $param_input, $msg );
				exit();

			default:
				$this->redirect_error( 
					$this->get_redirect_url(), 
					$this->_lang_err_someting.' (10)' );
				exit();
		}

// ログイン処理

		$code         = $this->_login->login_by_userid( 
			$user_id, $this->get_session_redirect() );
		$msg          = $this->_login->get_error_msg();
		$redirect_url = $this->_login->get_login_redirect_url();

		switch ( $code )
		{
			case 0:
				break;

			case -2:
				$this->redirect_error( 
					$this->get_redirect_url(), 
					$msg );
				exit();	

			default:
				$this->redirect_error( 
					$this->get_redirect_url(), 
					$this->_lang_err_someting.' (20)' );
				exit();
		}

// 認証パラメータを取得
		$param = unserialize( $this->get_session_auth() );

// 認証パラメータがなければ、エラー表示
		if ( !$this->check_auth_param($param) ) {
			$msg = $this->_lang_err_someting.' (2)';
			$this->redirect_error( 
				$this->get_redirect_url(), 
				$this->msg ); 
			exit();
		}

// 認証パラメータ を保存する
		$this->save_auth_or_redirect( $user_id, $param ); 

// 成功
		$this->redirect_success( 
			$redirect_url ,
			$this->_lang_registered );
		exit();
	}

//---------------------------------------------------------
// 関連付けを上書きする
// action: attach
//---------------------------------------------------------
	function execute_attach()
	{

// user_id を取得する
		$user_id = $this->_session->getParameter("_user_id");

// 取得出来ないときは、リダイレクトする
       	if ( empty($user_id) ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

// 認証パラメータを取得
		$param = unserialize( $this->get_session_auth() );

// トークンが正しくないなら、エラー表示
		if ( ! $this->check_token() ) {
			$msg = $this->_lang_err_someting.' (1)';
			$this->redirect_error( 
				$this->get_redirect_url(), 
				$this->msg ); 
			exit();
		}

// 認証パラメータがなければ、エラー表示
		if ( !$this->check_auth_param($param) ) {
			$msg = $this->_lang_err_someting.' (2)';
			$this->redirect_error( 
				$this->get_redirect_url(), 
				$this->msg ); 
			exit();
		}

// 上書きする指定のとき、関連付けを上書きする
		$override = $this->get_post_by_key('override');
		if ( $override == 1 ) {

// 認証パラメータ を保存する
			$ret = $this->save_user_auth( $user_id, $param );
			if ( !$ret ) {
				$this->redirect_error( 
					$this->get_redirect_url(), 
					$this->get_error_msg() ); 
				exit();
			}
		}

		$url = $this->get_redirect_url();
		header("Location: ". $url );
		exit();
	}

//---------------------------------------------------------
// 関連付けをクリアする
//---------------------------------------------------------
    function execute_clear()
    {
// user_id を取得する
		$user_id = $this->_session->getParameter("_user_id");

// 取得出来ないときは、リダイレクトする
       	if ( empty($user_id) ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

// 認証パラメータ を保存する
		$param = $this->build_auth_clear_param();
		$this->save_auth_or_redirect( $user_id, $param, true ); 

// 成功
		$this->redirect_success( 
			$this->get_redirect_url( true ),
			$this->_lang_cleared );
		exit();
	}

//---------------------------------------------------------
// コールバック処理
// action: callback
//---------------------------------------------------------
	function execute_callback( $param )
	{
		$user_id = $this->_session->getParameter("_user_id");

// ログイン中か否かで処理が異なる
       	if ( $user_id ) {
			$this->callback_when_login( $user_id, $param );
        } else {
			$this->callback_when_not_login( $param );
		}
}

//---------------------------------------------------------
// ログインしているときのコールバック処理
//---------------------------------------------------------
	function callback_when_login( $user_id, $param )
	{
		$auth_id = $this->get_auth_id( $param );
		$user_id_already = $this->get_userid_by_authid( $auth_id );

// 自分以外に使われていれば、エラー表示
		if ( $user_id_already && ($user_id != $user_id_already) ) {
			$msg  = $this->_lang_err_id_already .'<br />';
			$msg .= $auth_id ;
			$this->redirect_error(
				$this->get_redirect_url( true ), 
				$msg );
			exit();
		}

// 認証パラメータ を保存する
		$this->save_auth_or_redirect( $user_id, $param, true ); 

// 成功
		$this->redirect_success( 
			$this->get_redirect_url( true ),
			$this->_lang_id_changed );
		exit();
	}

//---------------------------------------------------------
// ログインしていないときのコールバック処理
//---------------------------------------------------------
	function callback_when_not_login( $auth_param )
	{
		$auth_id = $this->get_auth_id( $auth_param );
		$user_id = $this->get_userid_by_authid( $auth_id );

// 認証 ID が登録されていないなら、ログイン画面を表示する
		if ( empty($user_id) ) {

// 認証パラメータを保存
			$this->set_session_auth( serialize($auth_param) );

// ログイン画面を表示する
			$this->_form->callback_display_register_login_form();
			exit();
		}

// user 情報を取得する
		$user_param = $this->_login->get_login_user_param( $user_id );

// user 情報が取得できないときは、エラー表示
		if ( !$user_param ) {
			$this->redirect_error( 
				$this->get_redirect_url(), 
				$this->get_error_msg() );
			exit();
		}

// リダイレクトURLを取得
		$user_param['redirect_url'] = $this->get_session_redirect();

// ログイン処理
		$this->_login->login_excute( $user_param );
		$url = $this->_login->get_login_redirect_url();

// 成功
		$this->redirect_success( 
			$url, 
			$this->_lang_logined );
		exit();
	}

//---------------------------------------------------------
// 認証パラメータ
//---------------------------------------------------------
	function get_auth_id( $param )
	{
		if ( isset( $param[ $this->_item_name_id ] ) ) {
			return  $param[ $this->_item_name_id ] ;
		}
		return false;
	}

	function build_auth_clear_param()
	{
		$arr = array();
		foreach ( $this->_item_name_array as $name ) {
			$arr[ $name ] = '';
		}
		return $arr;
	}

	function check_auth_param( $param )
	{
		if ( !is_array($param) ) {
			return false;
		}

		foreach ( $this->_item_name_array as $name )
		{
			if ( !isset( $param[ $name ] )) {
				return false;
			}
			if ( empty( $param[ $name ] )) {
				return false;
			}
		}

		return true;
	}

//---------------------------------------------------------
// user_id を取得する
//---------------------------------------------------------
	function get_userid_by_authid( $id )
	{
		return $this->get_userid_by_key( 
			$this->_item_name_id, $id );
	}

	function get_userid_by_key( $key, $value )
	{
		$items = $this->get_users_items( $key, $value );
		if ( isset($items[0]['user_id']) ) {
			return $items[0]['user_id'];
		}
		return false;
	}

	function get_users_items( $key, $value )
	{
		if ( empty($key) || empty($value) ) {
			return false;
		}

		$where = array( 
			'item_name' => $key ,
			'content'   => $value ,
		);
		return $this->_usersView->getItems( $where );
	}

//---------------------------------------------------------
// users_item_link を取得する
//---------------------------------------------------------
	function get_authid_by_userid( $user_id )
	{
		return $this->get_users_item_link( 
			$user_id, $this->_item_name_id );
	}

	function get_users_item_link( $user_id, $name )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}

		return $this->get_users_item_link_by_id( $user_id, $item_id );
	}

	function get_users_item_link_by_id( $user_id, $item_id )
	{
		$item = $this->_usersView->getUserItemLinkById( $user_id, $item_id );
		if ( isset($item['content']) ) {
			return $item['content'];
		}
		return false;
	}

//---------------------------------------------------------
// users_item_link に格納する
//---------------------------------------------------------
	function save_auth_or_redirect( $user_id, $param, $flag_admin=false )
	{
// 認証パラメータ を保存する
		$ret = $this->save_user_auth( $user_id, $param );
		if ( !$ret ) {
			$this->redirect_error( 
				$this->get_redirect_url( $flag_admin ),
				$this->get_error_msg() );
			exit();
		}
		return true;
	}

	function save_user_auth( $user_id, $param )
	{
		$error = false;
		foreach ( $param as $name => $value )
		{
			$ret = $this->set_users_item_link( 
				$user_id, $name, $value );
			if ( !$ret ) {
				$error = true;
			}
		}
		if ( $error ) {
			return false;
		}
		return true;
	}

	function set_users_item_link( $user_id, $name, $value )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}

		$content = $this->get_users_item_link_by_id( $user_id, $item_id );

// 値が空のときもあるので、=== で判定する
		if ( $content === false ) {
			return $this->insert_users_item_link_by_id( $user_id, $item_id, $value );
		} else {
			return $this->update_users_item_link_by_id( $user_id, $item_id, $value );
		}
	}

	function insert_users_item_link_by_id( $user_id, $item_id, $value )
	{
		$public_flag          = 1;
		$email_reception_flag = 0;

		$params = array( 
			'user_id'              => $user_id ,
			'item_id'              => $item_id ,
			'public_flag'          => $public_flag ,
			'email_reception_flag' => $email_reception_flag ,
			'content'              => $value ,
		);

		$ret = $this->_usersAction->insUserItemLink( $params );
		if ( !$ret ) {
			$this->set_error_admin( $this->_usersAction->_db->ErrorMsg() );
			$this->set_error_code( 242 );
			return false;
		}
		return true;

	}

	function update_users_item_link_by_id( $user_id, $item_id, $value )
	{
		$params = array( 
			'content' => $value ,
		);

		$where = array( 
			'user_id' => $user_id ,
			'item_id' => $item_id ,
		);

		$ret = $this->_usersAction->updUsersItemsLink( $params, $where );
		if ( !$ret ) {
			$this->set_error_admin( $this->_usersAction->_db->ErrorMsg() );
			$this->set_error_code( 243 );
			return false;
		}
		return true;

	}

// === class end ===
}
?>