<?php
// $Id: Uninstall.class.php,v 1.1 2011/03/16 13:50:10 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2011-03-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_Uninstall extends Exauth_Common
{
    // コンポーネント
	var $_usersAction = null;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_Uninstall()
	{
		$this->Exauth_Common();

		$this->init_dicontainer('uninstall.dicon.ini');
		$this->init_component_common();
		$this->init_component();
//		$this->init_smarty_assign('uninstall.maple.ini');
	}

    function init_component()
    {
		$this->_usersAction =& $this->_container->getComponent("usersAction");
	}

//---------------------------------------------------------
// アンインストールを行う
//---------------------------------------------------------
	function execute_uninstall()
	{
		$this->_exec_uninstall();

// 常に true を返す。 false を返すとアンインストールできない。
		return true;
	}

	function _exec_uninstall()
	{
		$this->clear_compiled_tpl_in_module();

		$items = $this->get_module_item_name_list();
		if ( !is_array($items) || !count($items) ) {
			echo "item name が取得できない : Exauth_Uninstall <br />\n";
			return false;
		}

		$ret = $this->delete_user_items( $items );
		if ( !$ret ) {
			return false;
		}

		$ret = $this->delete_uploads_path();
		if ( !$ret ) {
			return false;
		}

	}

//---------------------------------------------------------
// ユーザ項目を削除
//---------------------------------------------------------
	function delete_user_items( $items )
	{
		$error = false;

		foreach ( $items as $name ) 
		{
			$item_id = $this->get_item_id_by_name( $name );
			if ( !$item_id ) {
				$error = true;
				echo "item name : $name が取得できない : Exauth_Uninstall <br />\n";
				continue;
			}

			$ret = $this->_usersAction->delItemById( $item_id );
			if ( !$ret ) {
				$error = true;
				echo "item name: $item_id が削除できない : Exauth_Uninstall <br />\n";
			}
		}

		if ( $error ) {
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// uploads の ディレクトリを削除する
//---------------------------------------------------------
	function delete_uploads_path() 
	{
		$path = $this->get_module_uploads_dir( false );
		if ( !is_dir( $path ) ) {
			return true;
		}

		$ret = $this->delete_files_recursive( $path );
		if ( !$ret ) {
			return false;
		}
		return true;
	}

	function delete_files_recursive( $path ) 
	{
    	if ( !file_exists($path) || !is_dir($path) ) {
			return true;
		}

		$lists = $this->get_lists_in_dir( $path );

// 自分のディレクトリにファイルがあれば、
		if ( is_array($lists) ) {
			foreach ( $lists as  $list )
			{
// 自分自身を除く
				if ( $list == '.' ) {
					continue;
				}
// 親ディレクトリを除く
				if ( $list == '..' ) {
					continue;
				}

				$path_list = $path . "/" . $list;

// ディレクトリであれば、再帰呼び出し
				if ( is_dir( $path_list ) ) {
					$this->delete_files_recursive( $path_list );

// ファイルであれば、削除
				} elseif ( is_file( $path_list ) ) {
	  				unlink( $path_list );
				}
 	       }
		}

// 自分のディレクトリを削除
		$ret = rmdir( $path );
		if ( !$ret ) {
			return false;
		}
		return true;
	}

// === class end ===
}
?>