<?php
// $Id: User.class.php,v 1.2 2011/03/16 13:50:10 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// Exauth_Common
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;

class Exauth_User extends Exauth_Common
{
	// Zbgϐ
	var $_entry_label  = null;
	var $_item_name_id = null;

/**
 * RXgN^[
 *
 * @access	public
 */
	function Exauth_User() 
	{
		$this->Exauth_Common();

//		$this->init_dicontainer('user.dicon.ini');
		$this->init_component_common();
//		$this->init_component();
//		$this->init_smarty_assign('user.maple.ini');
	}

    function set_dirname_user( $dirname )
	{
		$this->set_dirname( $dirname );

		$this->init_item_name_id();
		$this->init_entry_label();
	}

    function init_component()
    {
		// dummy
	}

    function init_entry_label()
	{
		$name  = $this->_dirname.'_ENTRY_LABEL';
		$value = $this->get_constant( $name );
		$this->set_entry_label( $value );
	}

    function set_item_name_id( $v )
	{
		$this->_item_name_id = $v;
	}

    function set_entry_label( $v )
	{
		$this->_entry_label = $v;
	}

//---------------------------------------------------------
// auth_param
//---------------------------------------------------------
	function build_auth_param( $user_id )
	{
	    $auth = array(
			'dirname' => $this->_dirname ,
    		'value'   => $this->get_value( $user_id ) ,
    		'label'   => $this->get_entry_label() ,
			'icon'    => $this->build_icon_by_dirname( $this->_dirname ) ,
			'action_auth'  => $this->build_action_auth_by_dirname( $this->_dirname ) ,
			'action_clear' => $this->build_action_clear_by_dirname( $this->_dirname ) ,
		);
		return $auth;
	}

	function get_value( $user_id )
	{
		return $this->get_users_item_link( $user_id, $this->_item_name_id );
	}

	function get_entry_label()
	{
		return $this->_entry_label;
	}

	function build_action_auth_by_dirname( $dirname )
	{
		$str = $dirname.'_view_main_auth&mode=1';
		return $str;
	}

	function build_action_clear_by_dirname( $dirname )
	{
		$str = $dirname.'_action_main_clear';
		return $str;
	}

	function build_icon_by_dirname( $dirname )
	{
		$str = 'images/'.$dirname.'/default/'.$dirname.'_icon.gif';
		return $str;
	}

//---------------------------------------------------------
// usersView
//---------------------------------------------------------
	function get_users_item_link( $user_id, $name )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}
		return $this->get_users_item_link_by_id( $user_id, $item_id );
	}

	function get_users_item_link_by_id( $user_id, $item_id )
	{
		$item = $this->_usersView->getUserItemLinkById( $user_id, $item_id );
		if ( isset($item['content']) ) {
			return $item['content'];
		}
		return false;
	}

	function get_item_id_by_name( $name )
	{
		if ( empty($name) ) {
			return false;
		}

		$item_params = array(
			'item_name' => $name
		);

		$items = $this->_usersView->getItems( $item_params );

		$item_id = 0;
		if ( isset($items[0]['item_id']) ) {
			$item_id = $items[0]['item_id'];
		}

		if ( empty($item_id) ) {
			return false;
		}

		return $item_id;
	}

// === class end ===
}

?>