<?php
// $Id: View.class.php,v 1.5 2011/03/25 02:49:56 ohwada Exp $

//=========================================================
// Exauth Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 1K.OHWADA
// Common.class.php
//---------------------------------------------------------

//---------------------------------------------------------
// TODO
// exauthentry にリダイレクトする
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR.'/webapp/components/exauth/Common.class.php' ;
include_once BASE_DIR.'/webapp/components/exauth/Form.class.php' ;

class Exauth_View extends Exauth_Common
{
	// コンポーネント
	var $_form        = null;

	// 内部変数
	var	$_user_id   = null;
	var $_auth_mode = null;

	// 言語変数
	var $_lang_redirect_message = null ;
	var $_lang_redirect_submit  = null ;
	var $_lang_incorrect_login  = null ;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauth_View() 
	{
		$this->Exauth_Common();

//		$this->init_dicontainer('view.dicon.ini');
		$this->init_component_common();
		$this->init_component();
//		$this->init_smarty_assign('view.maple.ini');
	}

    function set_dirname_view( $dirname )
	{
		$this->set_dirname( $dirname );
		$this->init_module_id();
		$this->init_item_name_id();

		$this->_action_register = $dirname.'_action_main_register';
		$this->_action_login    = $dirname.'_action_main_login';
		$this->_action_select   = $dirname.'_action_main_attach';

		$this->set_lang_common();
		$this->set_lang_view();
//		$this->set_lang_by_dirname( $dirname );

		$this->_form->set_dirname_form( $dirname );
	}

	function set_lang_view() 
	{
		$this->_lang_redirect_message   = EXAUTH_GOTO_AUTH_PAGE ;
		$this->_lang_redirect_submit    = EXAUTH_CLICK_HERE ;
		$this->_lang_incorrect_login    = EXAUTH_INCORRECT_LOGIN ;
	}

    function set_lang_by_dirname( $dirname )
	{
		// dummy
	}

    function init_component()
    {
		$this->_form = new Exauth_Form();
	}

//---------------------------------------------------------
// user_id を取得する
// view: init
//---------------------------------------------------------
	function get_init_userid_or_exauthentry()
	{

// リダイレクト先を保存する
		$this->set_session_redirect_with_current_url();

		$user_id = $this->_session->getParameter("_user_id");

// ログインしてなければ、ログイン要求を表示する
       	if ( empty($user_id) ) {
			$this->redirect_location_exauthentry();
			return false;
		}

		return $user_id;
	}

//---------------------------------------------------------
// config を取得する
//---------------------------------------------------------
    function is_config_use_ssl_on()
	{
		if ( $this->get_config_use_ssl() == _ON ) {
			return true;
		}
		return false;
	}

    function get_config_use_ssl()
	{
		return $this->get_config_general_by_key( 'use_ssl' );
	}

    function get_config_closesite()
	{
		return $this->get_config_general_by_key( 'closesite' );
	}

    function get_config_general_by_key( $key )
	{
		$config = $this->get_config_general();
		$val    = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

//---------------------------------------------------------
// url の区切り記号を取得する
// action: post
//---------------------------------------------------------
	function get_seprator_from_url( $url )
	{
		return $this->get_separator_from_type( $this->analyze_url_type( $url ) );
	}

//---------------------------------------------------------
// analyze_url_type
//
// url:
//   type 0: unknown
//   type 1: foo.php
//   type 2: foo.php?
//   type 3: foo.php?bar=abc
//---------------------------------------------------------
	function analyze_url_type( $url )
	{
		$type = 0;	// foo.php

// set url_type, if ? in url
		if ( preg_match('/\?/', $url) ) {
			$url_arr = explode('?', $url);
			if ( $url_arr[1] ) {
				$type = 3;	// foo.php?bar=abc
			} else {
				$type = 2;	// foo.php?
			}
		} else {
			$type = 1;	// foo.php
		}

		return $type;
	}

	function get_separator_from_type( $type )
	{
		$str = '';
		switch ($type)
		{
		case 1:
			$str = '?';
			break;

		case 2:
			$str = '';
			break;

		case 3:
			$str = '&';
			break;
		}
		return $str;
	}

//---------------------------------------------------------
// server へのリダイレクトを表示する
//---------------------------------------------------------
	function redirect_server_with_post( $url, $args )
	{
		$time_msec = 1000 * $this->_REDIRECT_TIME_SERVER;

		$action = array(
			'url'       => $url ,
			'args'      => $args ,
			'time_msec' => $time_msec ,
		);

		$lang = array(
			'redirect_message' => $this->_lang_redirect_message ,
			'redirect_submit'  => $this->_lang_redirect_submit ,
		);

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->_form->display_redirect_server( $assign );
		exit();
	}

//---------------------------------------------------------
// テンプレートを表示する
//---------------------------------------------------------
	function display_template( $assign, $template_dir, $template )
	{
		$this->_form->display_template( 
			$assign, $template_dir, $template );
	}

//---------------------------------------------------------
// ベースのURLを取得する
// view: init
//---------------------------------------------------------
	function get_base_url_ssl() 
	{
		list( $url, $show ) =
			$this->get_base_url_ssl_and_show();
		return $url;
	}

//---------------------------------------------------------
// ベースのURLを取得する
//---------------------------------------------------------
	function get_base_url_ssl_and_show() 
	{
		$show = false;

// SSL ログイン設定だが、https タイプ でないときは、https タイプに変換する
		if ( $this->is_config_use_ssl_on() &&
			!$this->is_base_url_https() ) {
			$url  = $this->get_base_url_when_use_ssl_login();
			$show = true;

// そうでなければ、http or https タイプ
		} else {
			$url = $this->get_base_url();
		}

		return array( $url, $show );
	}

	function get_base_url_when_use_ssl_login()
	{
		$url = preg_replace("/^http:\/\//i","https://", BASE_URL);
		return $url;
	}

	function is_base_url_https()
	{
		$is = preg_match("/^https:\/\//i", BASE_URL);
		return $is;
	}

//---------------------------------------------------------
// exauthentry にリダイレクトする
// view: init
//---------------------------------------------------------
    function redirect_location_exauthentry()
    {
		$ret = $this->module_installed_by_dirname( 'exauthentry' );
		if ( $ret ) {
			$url = BASE_URL.'/index.php?action=exauthentry_view_main_init';
// TODO
//			header("Location: ". $url );
//			exit();
		}
	}

//---------------------------------------------------------
// ログインしているか
// view: auth
//---------------------------------------------------------
	function auth_is_login_or_redirect_location()
	{
		$ret = $this->is_login_or_redirect_location();
		$this->set_session_redirect_with_referer_if_not_set();
		return $ret;
	}

//---------------------------------------------------------
// ログインしているか
//---------------------------------------------------------
	function is_login_or_redirect_location()
	{
		$this->_user_id   = $this->_session->getParameter("_user_id");
		$this->_auth_mode = $this->get_get_by_key('mode');

// ログイン中のとき、関連付けでなければ
       	if ( $this->_user_id && ($this->_auth_mode == 0) ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

       	if ( $this->_user_id ) {
			return true;
		}
		return false;
	}

	function get_user_id()
	{
		return $this->_user_id;
	}

	function get_auth_mode()
	{
		return $this->_auth_mode;
	}

//---------------------------------------------------------
// 既にログイン済なら、リダイレクトする
//---------------------------------------------------------
	function redirect_location_if_login()
	{
// ログイン中のとき
       	if ( $this->_session->getParameter("_user_id") ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }
	}

//---------------------------------------------------------
// セッション user_id を取得する
// 取得できなければ、リダイレクトする
// action: post
//---------------------------------------------------------
	function get_session_userid_or_redirect_location()
	{
		$user_id = $this->_session->getParameter("_user_id");

// ID なければ、リダイレクト
       	if ( empty($user_id) ) {
			header("Location: ". BASE_URL.'/' );
			exit();
        }

		return $user_id;
	}

//---------------------------------------------------------
// リダイレクトする
// action: post
//---------------------------------------------------------
	function redirect_location_post( $code, $msg=null )
	{
		$this->set_session_post( $msg );

		$redirect = $this->get_session_redirect();
		if ( $redirect ) {
			$separator = $this->get_seprator_from_url( $redirect );
			$url  = $redirect . $separator ;
			$url .= 'code='.$code;

		} else {
			$url = BASE_URL.'/';
		}

		header("Location: ". $url );
		exit();
	}

//---------------------------------------------------------
// リダイレクト先を設定する
//---------------------------------------------------------
	function set_session_redirect_with_referer_if_not_set()
	{
		$url = $this->get_session_redirect();

// リダクレクト先が設定されてなければ、referer を設定する
		if ( empty($url) ) {
			$this->set_session_redirect_with_referer();
		}
	}

//---------------------------------------------------------
// リダイレクト先を設定する 現在のURL
// view: init
//---------------------------------------------------------
    function set_session_redirect_with_current_url()
	{
		$this->set_session_redirect( 
			$this->get_current_url() );
	}

//---------------------------------------------------------
// リダイレクト先を設定する
//---------------------------------------------------------
	function set_session_redirect_with_referer()
	{
		$url = $this->get_server_http_referer();
// サイト内であれば
		if ( strpos( $url, BASE_URL ) === 0 ) {
			$this->set_session_redirect( $url );
		}
	}

//---------------------------------------------------------
// current_url を取得する
// http://framework.zend.com/manual/ja/zend.gdata.photos.html
//---------------------------------------------------------
	function get_current_url()
	{
		$protocol    = $this->get_http_protocol();
		$port        = $this->get_server_port( $protocol );
		$host        = $this->get_server_by_key( 'HTTP_HOST' );
		$request_uri = $this->get_server_by_key( 'REQUEST_URI' );

		$str = $protocol . $host . $port . $request_uri ;
		return $str;
	}

	function get_http_protocol()
	{
		if ( $this->is_server_https_on() ) {
        	$str = 'https://';
    	} else {
	        $str = 'http://';
	    }
		return $str;
	}

	function get_server_port( $protocol )
	{
		$server_port = $this->get_server_by_key( 'SERVER_PORT' );
		if ( $server_port &&
           (($protocol == 'http://'  && $server_port != '80') ||
            ($protocol == 'https://' && $server_port != '443'))) {
            $port = ':' . $server_port;
		} else {
        	$port = '';
    	}
		return $port;
	}

//---------------------------------------------------------
// リダイレクトする
// view: callback auth
//---------------------------------------------------------
    function redirect_error_msg( $msg, $flag_admin=false )
    {
		$this->redirect_error( 
			$this->get_redirect_url( $flag_admin ), 
			$msg );
		exit();
	}

//---------------------------------------------------------
// モジュールのオプションを取得する
// view: init
//---------------------------------------------------------
    function get_show_login_nc()
    {
		return $this->get_module_option_config_by_key( 'show_login_nc' );
	}

    function get_show_login_openid_form()
    {
		return $this->get_module_option_config_by_key( 'show_login_openid_form' );
	}

// === class end ===
}

?>