<?php
// $Id: View.class.php,v 1.2 2011/03/16 14:24:21 ohwada Exp $

//=========================================================
// Exauthadmin Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// execute()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Exauthadmin_Components_View
{
   // 使用コンポーネントを受け取るため
	var $_container   = null;
	var $_session     = null;
	var $_modulesView = null;

    // 値をセットするため
    var $content = null;
    var $require_module = null;
	var $lang_require = null;

	/**
	 * execute実行
	 *
	 * @access  public
	 */
    function Exauthadmin_Components_View()
    {
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_session     =& $this->_container->getComponent("Session");
		$this->_modulesView =& $this->_container->getComponent("modulesView");
    }

    function execute( $dirname )
    {
		$return       = 'error';
 		$content      = null;
		$require      = null;
		$lang_require = $this->lang_require_by_dirname( $dirname );

	    $flag = $this->module_installed_by_dirname( $dirname );
		if ( !$flag ) {
			$require = 1;
			$return  = 'success';	

		} else {
			$content = $this->get_content_by_dirname( $dirname );
			if ( $content ) {
  				$return = 'success';
			}
		}

		$param = array(
			'lang_require' => $lang_require ,
			'require'      => $require ,
			'content'      => $content ,
			'return'       => $return ,
		);

		return $param;
    }

    function lang_require_by_dirname( $dirname )
	{
		$name = strtoupper( 'EXAUTHADMIN_REQUIRE_'.$dirname );
		if ( defined($name) ) {
			$lang = constant($name);
		} else {
			$lang = $name;
		}
		return $lang;
	}

    function module_installed_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return true;	
		}
		return false;
	}

	function get_content_by_dirname( $dirname )
	{
		$file = BASE_DIR.'/webapp/modules/'. $dirname .'/components/Admin.class.php' ;
		$class = ucfirst( $dirname ).'_Components_Admin';

		if ( !file_exists($file) ) {
			return false;
		}

		include_once $file;

		if ( !class_exists($class) ) {
			return false;
		}

		$admin = new $class;
		$admin->set_block_id( $this->_session->getParameter("_id") );
		return $admin->view();
	}

// === class end ===
}
?>