<?php
// $Id: View.class.php,v 1.4 2011/03/25 03:01:05 ohwada Exp $

//=========================================================
// Exauth Entry Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// excute_entry()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

include_once BASE_DIR.'/webapp/components/exauth/View.class.php' ;

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Exauthentry_Components_View extends Exauth_View
{

	var $_opt_show_login_nc          = true;
	var $_opt_show_login_openid_form = true;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Exauthentry_Components_View() 
	{
		$log =& LogFactory::getLog();
		$log->trace("component exauthentry View のコンストラクタが実行されました", "exauthentryVIew##Exauthentry_VIew");

		$this->Exauth_View();
		$this->set_dirname_view( 'exauthentry' );
		$this->init_module_option();
	}

//---------------------------------------------------------
// エントリ画面を表示する
//---------------------------------------------------------
	function excute_entry() 
	{

//既にログイン済なら、リダイレクトする
		$this->redirect_location_if_login();

		$error_mes    = $this->get_get_by_key('error_mes');
		$redirect_url = $this->get_get_by_key('_redirect_url');

// リダイレクトURLを保存
		if ( $redirect_url ) {
			$this->set_session_redirect( $redirect_url );
		} else {
			$this->set_session_redirect_with_referer();
		}

		$this->display_entry_form( $error_mes );
	}

//---------------------------------------------------------
// login に使用するモジュールを生成する
//---------------------------------------------------------
	function build_login_modules()
	{
		$dirnames   = explode('|', EXAUTHENTRY_MODULES);
		$show_array = array();
		$lang_array = array();

		foreach ( $dirnames as $dirname )
		{

// 表示するかいなか
			$show_array[ $dirname ] = 
				$this->module_installed_by_dirname( $dirname );

// 表示するタイトル
			$name = strtoupper( 'EXAUTHENTRY_LOGIN_'.$dirname );

// 言語定数が定義されていれば
			if ( defined($name) ) {
				$lang =	constant($name);
			} else {
				$lang =	$name;
			}

			$lang_array[ $dirname ] = $lang;
		}
		
		return array( $show_array, $lang_array);
	}

//---------------------------------------------------------
// enter フォームを表示する
//---------------------------------------------------------
	function display_entry_form( $show_redirect_mes )
	{
		list ( $show_login_modules, $lang_login_modules ) =
			$this->build_login_modules();

		list( $base_url, $show_ssl_login ) = 
			$this->get_base_url_ssl_and_show();

		$action = array(
			'base_url'            => $base_url ,
			'show_ssl_login'      => $show_ssl_login ,
			'show_redirect_mes'   => $show_redirect_mes ,
			'show_login_modules'  => $show_login_modules ,
			'lang_login_modules'  => $lang_login_modules ,
			'show_login_nc'          => $this->_opt_show_login_nc ,
			'show_login_openid_form' => $this->_opt_show_login_openid_form ,
		);

		$lang = array(
			'exauthentry_login'          => EXAUTHENTRY_LOGIN ,
			'exauthentry_login_nc'       => EXAUTHENTRY_LOGIN_NC ,
			'exauthentry_login_google'   => EXAUTHENTRY_LOGIN_GOOGLE ,
			'exauthentry_login_yahoo_jp' => EXAUTHENTRY_LOGIN_YAHOO_JP ,
			'exauthentry_login_mixi'     => EXAUTHENTRY_LOGIN_MIXI ,
			'exauthentry_login_livedoor' => EXAUTHENTRY_LOGIN_LIVEDOOR ,
			'exauthentry_login_flickr'   => EXAUTHENTRY_LOGIN_FLICKR ,
			'exauthentry_ssl_login'      => EXAUTH_SSL_LOGIN ,
			'exauthentry_cancel'         => EXAUTH_CANCEL ,
			'exauthentry_redirect_mes'   => _LOGINAGAIN_MES ,
		);

		$assign = array(
			'action' => $action , 
			'lang'   => $lang ,
		);

		$this->display_template( 
			$assign, 
			$this->get_module_template_main_dir(), 
			'exauthentry_entry.html' );

		$this->display_template( 
			$assign, $this->_template_dir, 'exauthentry_entry.html');
		exit();
	}

// === class end ===
}

?>