/* $Id: exauthentry.js,v 1.1.1.1 2010/09/07 09:09:00 ohwada Exp $ */
/* =========================================================
 * K.OHWADA 2010-08-01
 * reference login/files/js/default/login.js
 * =========================================================
*/

var clsExauthentry = Class.create();
var exauthentryCls = Array();

clsExauthentry.prototype = {
	initialize: function(id) {
		this.id = id;
		this.login_id = null;
		this.password = null;
		this.tokenValue = null;
		this.sslPopup = null;
		this.block_id = null;
		this.op = null;
		this.base_url = null;
	},
	exauthentryActionInit: function(event) {
//
// op 入力の処理
//
		this.op =  $("op" + this.id);
		var op  = $F("op" + this.id);
		var msg = $F("msg_op" + this.id);

// op が入力されていないときは、エラー表示
		if ( op == '' ) {
			commonCls.alert( msg );
			setTimeout(this.exauthentryFocus.bind(this.op), 100);

// op が入力されていれば、auth 処理
		} else {
			var href = this.base_url + "/index.php?action=exauthentry_view_main_auth&op=" + op;
			location.href = href;
		}
	},
	exauthentryLoginInit: function() {
		this.login_id = $("login_id" + this.id);
		this.password = $("password" + this.id);
		setTimeout(this.exauthentryFocus.bind(this.login_id), 200);
	},
	exauthentryEnterAction: function(event, prefix_id_name, token_value) {
		if (event.keyCode == 13) {
			this.exauthentryAction(event, prefix_id_name, token_value);
			return false;
		}
		return true;
	},
	exauthentryLoginAction: function(event, prefix_id_name, token_value) {
		//Event.element(event).onblur();
		//
		// ログイン処理
		//
		var top_el = $(this.id);
		var login_id = $F("login_id" + this.id);
		var password = $F("password" + this.id);
		if($("exauthentry_rememberme" + this.id)) {
			var rememberme = $F("exauthentry_rememberme" + this.id);
		} else {
			var rememberme = 0;
		}
		var redirect_url = $_GET('_redirect_url');
		if(redirect_url == undefined) {
			redirect_url = "";
		}
		
		//パラメータ取得
		var exauthentry_params = new Object();
	
		exauthentry_params["method"] = "post";
		exauthentry_params["param"] = {"action":"exauthentry_action_main_init",
								 "login_id":login_id,
								 "password":password,
								 "rememberme":rememberme,
								 "_redirect_url":redirect_url};
		if (this.tokenValue) {
			exauthentry_params["param"]["block_id"] = this.block_id;
			exauthentry_params["param"]["_token"] = this.tokenValue;
		}
		exauthentry_params["top_el"] = top_el;
		exauthentry_params["loading_el"] = top_el;
		exauthentry_params["callbackfunc"] = function(res){this.exauthentryComplete(res);}.bind(this);
		exauthentry_params["callbackfunc_error"] = function(res){this.exauthentryComplete(res);}.bind(this);

		commonCls.send(exauthentry_params);
		
	},
	exauthentryLogout: function(event) {
		var load_el = Event.element(event);
		//パラメータ取得
		var logout_params = new Object();
		var top_el = $(this.id);
		
		logout_params["method"] = "post";
		logout_params["param"] = {"action":"exauthentry_action_main_logout"};
		//logout_params["top_el"] = top_el;
		logout_params["loading_el"] = load_el;
		//logout_params["match_str"] = null;
		logout_params["callbackfunc"] = function(res){this.exauthentryComplete(res);}.bind(this);
		logout_params["callbackfunc_error"] = function(res){this.exauthentryComplete(res);}.bind(this);

		commonCls.send(logout_params);
	},
	exauthentryComplete: function(res) {
		var location_href = res.match("location\.href");
		if(location_href == null) {
			if(res.match(":")) {
				var mesArr = res.split(":");
				var alert_res = "";
				for(var i = 1; i < mesArr.length; i++) {
					alert_res += mesArr[i];
				}
				
				if(res.match("^(login_id|password|login_id,password|login_id,password,md5):")) {
					//メッセージ表示
					commonCls.alert(alert_res);
					//フォーカスの移動
					if(mesArr[0] == "login_id,password") {
						setTimeout(this.exauthentryFocus.bind(this.login_id), 100);
						this.password.value="";
					} else if(mesArr[0] == "login_id")
						setTimeout(this.exauthentryFocus.bind(this.login_id), 100);
					else {
						setTimeout(this.exauthentryFocus.bind(this.password), 100);
					}	
				} else {
					commonCls.alert(res);
				}
			} else {
				commonCls.alert(res);
			}
		}
	},
	exauthentryFocus: function() {
		var el = $(this);

		//フォーカスの移動
		commonCls.focus(el);
	},
	insAutoregist: function (form_el) {
		var reg_params = new Object();
		reg_params["param"] = {'action': "exauthentry_action_main_autoregist"};
		reg_params["form_el"] = form_el;
		reg_params["top_el"] = $(this.id);
		reg_params["target_el"] = $("target"+this.id);
		reg_params["method"] = "post";
		reg_params['form_prefix'] = "exauthentry_attachment";
		reg_params["callbackfunc_error"] = function(file_list, res){
			// エラー時(File)
			this.focusError(res);
		}.bind(this);
		commonCls.sendAttachment(reg_params);
	},
	focusError: function(res) {
		res = commonCls.cutErrorMes(res);
		if(res.match(":")) {
			var mesArr = res.split(":");
			var alert_res = "";
			for(var i = 1; i < mesArr.length; i++) {
				alert_res += mesArr[i];
			}
			// チェックボックス等の場合、うまく動作しないかも
			var focus_el = $("exauthentry_items"+ this.id + "_" + mesArr[0])
			if(focus_el) {
				commonCls.alert(alert_res);
				commonCls.focus(focus_el);
			} else {
				commonCls.alert(res);
			}
		} else {
			commonCls.alert(res);
		}
	},
	focusBtn: function(this_el) {
		if(!browser.isNS){
			Element.removeClassName(this_el, 'exauthentry_popup_btn'); 
			Element.addClassName(this_el, 'exauthentry_popup_act_btn');
		}
	},
	blurBtn: function(this_el) {
		if(!browser.isNS){
			Element.addClassName(this_el, 'exauthentry_popup_btn');
			Element.removeClassName(this_el, 'exauthentry_popup_act_btn');
		}
	}
}