<?php
// $Id: Install.class.php,v 1.1.1.1 2010/09/07 09:12:22 ohwada Exp $

//=========================================================
// Exauth User Netcommons
// K.OHWADA 2010-08-01
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Exauthuser_Install extends Action
{
	var $authoritiesView   = null ;
	var $authoritiesAction = null ;
	var $modulesView       = null ;

	function execute()
	{
		$module_id = $this->get_module_id_by_dirname( 'exauthuser' );
		if ( empty($module_id) ) {
			return true;
		}

		$this->ins_authority_module_link( $module_id );
		return true;
	}

	function get_module_id_by_dirname( $dirname )
	{
	    $module = $this->modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return $module['module_id'];	
		}
		return false;
	}

//---------------------------------------------------------
// Refer: Module_Action_Admin_Install
//---------------------------------------------------------
	function ins_authority_module_link( $module_id )
	{
		$authority_link_flag = true;

		$auth_where_params = array();
		$authorities_obj = $this->authoritiesView->getAuthorities( $auth_where_params );
		if ( !isset($authorities_obj[0]) ) {
			return false;
		}

		foreach ($authorities_obj as $authoritiy) 
		{
			$authority_param = array(
				"role_authority_id" => $authoritiy['role_authority_id'],
				"module_id"         => $module_id,
				"authority_id"      => $authoritiy['user_authority_id']
			);

			$ret = $this->authoritiesAction->insAuthorityModuleLink($authority_param);
			if ( !$ret ) {
				$authority_link_flag = false;	
			}
		}

		return $authority_link_flag;
	}

// === class end ===
}
?>
