<?php
/**
@brief ѤΥȥ꡼ե륿
@version $Id: AdminEntryFilter.php,v 1.3 2004/07/27 10:11:43 minahito Exp $
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";

class AdminEntryFilter extends exAbstractFilterForm {
	var $id_=null;
	var $sort_=array ("lid","id","uid","entry_date","update_date","status","comment");

	function fetch()
	{
		$this->id_=$this->getPositiveIntger('id');
	}

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);

		if($this->id_) {
			$criteria->add(new Criteria("id",$this->id_));
		}
		return $criteria;
	}

	function getExtra()
	{
		$ret=array();
		$ret['id']=$this->id_;
		return $ret;
	}
}

class AdminEntryTableModel extends exListTableModel {
	var $_column_=array("LID","ID","UID","UNAME","ENTRY_DATE","UPDATE_DATE","STATUS","COMMENT","ACTION");
	var $filter_;

	function AdminEntryTableModel($component=null)
	{
		parent::exListTableModel($component);
		if(!$this->filter_)
			$this->filter_=new AdminEntryFilter();
	}

	function init() {
		$handler = bxParty::getHandler('entry');

		$this->listController_=new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->fetch($handler->getCount($this->filter_->getCriteria()),20);

		$objs = $handler->getObjects($this->listController_->getCriteria());

		foreach ( $objs as $obj ) {
			// ΤۤäᤤΤǡȥ饯㡼
			$this->_row_data_[]=$obj->getStructure();
		}

		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	function getValueAtChk($arr)
	{
		return "<input type='checkbox' name='id[]' value='".$arr['id']."'>";
	}

	function getValueAtInput_date($arr)
	{
		return formatTimestamp($arr['input_date']);
	}

	function getValueAtEntry_date($arr)
	{
		return formatTimestamp($arr['entry_date']);
	}

	function getValueAtUpdate_date($arr)
	{
		return formatTimestamp($arr['update_date']);
	}

	function getValueAtStatus($arr)
	{
		return $arr['status']['name'];
	}

	function getValueAtUname($arr)
	{
		return isset($arr['xoopsuser']) ? $arr['xoopsuser']['uname'] : "Guest";
	}

	function getValueAtAction($arr)
	{
		$ret=@sprintf("<a href='%s'>%s</a> | ","../entry.php?lid=".$arr['lid']."&amp;id=".$arr['id'],"EDIT").
			@sprintf("<a href='%s'>%s</a>","../entry_delete.php?lid=".$arr['lid']."&amp;id=".$arr['id'],"DELETE");
		return $ret;
	}
}

?>