<?php
/**
@brief ѤΥơե륿
@version $Id: AdminStatusFilter.php,v 1.3 2004/07/26 11:09:16 minahito Exp $
*/

require_once "exForm/Filter.php";
require_once "exComponent/table/ListTable.php";

class AdminStatusFilter extends exAbstractFilterForm {
	var $sort_=array ("id","name","ex","priority","type");

	function getCriteria($start=0,$limit=0,$sort=0)
	{
		$criteria = $this->getSortCriteria($start,$limit,$sort);
		return $criteria;
	}

	function getDefaultCriteria($start,$limit)
	{
		$criteria=parent::getDefaultCriteria($start,$limit);
		$criteria->setSort('priority');
		$criteria->setOrder('ASC');

		return $criteria;
	}
}

class AdminStatusTableModel extends exListTableModel {
	var $_column_=array("ID","NAME","EX","PRIORITY","TYPE","ACTION");
	var $filter_;

	function AdminStatusTableModel($component=null)
	{
		parent::exListTableModel($component);
		if(!$this->filter_)
			$this->filter_=new AdminStatusFilter();
	}

	function init() {
		$handler = bxParty::getHandler('status');

		$this->listController_=new ListController();
		$this->listController_->filter_=&$this->filter_;
		$this->listController_->fetch($handler->getCount($this->filter_->getCriteria()),20);

		$objs = $handler->getObjects($this->listController_->getCriteria());

		foreach ( $objs as $obj ) {
			$this->_row_data_[]=$obj->getArray();
		}

		return COMPONENT_MODEL_INIT_SUCCESS;
	}

	function getValueAtAction($arr)
	{
		$ret=@sprintf("<a href='%s'>%s</a>","status.php?id=".$arr['id'],_MD_A_BXPARTY_LANG_EDIT);
		return $ret;
	}
}

?>