<?php
require_once DISCUSS_PATH . '/class/attendee.php';
require_once DISCUSS_PATH . '/class/general/xoopssimplecontroller.php';

class DiscussAttendeeAdminList extends XoopsTableObjectList
{
	function DiscussAttendeeAdminList()
	{
		$this->addElement('discuss_id', 'discuss', 100, array('sort'=>true, 'filter'=>true, 'method'=>'id2name', 'class'=>'discussion'));
		$this->addElement('sess_id', 'session id', 20, array('sort'=>true));
		$this->addElement('uid', 'uid', 20, array('sort'=>true, 'filter'=>true));
		$this->addElement('uname', 'uname', 100);
		$this->addElement('updated', 'updated', 150, array('sort'=>true, 'method'=>'time2str', 'format'=>'m/d H:i'));
		$this->addElement('status', 'status', 50, array('sort'=>true, 'filter'=>true, 'method'=>'key2val', 'var_arr'=>array(0=>'inactive',1=>'active')));
		$this->addElement('__SimpleDeleteLink__', '', 50);
	}

	function getSelf() {
		return DISCUSS_URL . '/admin/index.php/attendee';
	}
}

class DiscussAttendeeAdminController extends XoopsSimpleAdminController
{
	function DiscussAttendeeAdminController()
	{
		parent::XoopsSimpleAdminController('DiscussAttendee', _AD_DISCUSS_LANG_ATTENDEE);
		$this->allowedOp = array('list','delete','deleteok','deleteall','deleteallok');
		$this->url = DISCUSS_URL . '/admin/index.php/attendee';
	}
}
?>