<?php
require_once DISCUSS_PATH . '/class/discussion.php';
require_once DISCUSS_PATH . '/class/general/xoopssimplecontroller.php';

class DiscussDiscussionAdminList extends XoopsTableObjectList
{
	function DiscussDiscussionAdminList()
	{
		$this->addElement('discuss_id', 'id', 20, array('sort'=>true));
		$this->addElement('subject', _AD_DISCUSS_LANG_AGENDA, 120, array('sort'=>true));
		$this->addElement('description', _AD_DISCUSS_LANG_DESCRIPTION, 500);
		$this->addElement('count_message_id_', 'message', 50, array('extraVar'=>'__ExtraVar__', 'sort'=>true, 'filter'=>true));
		$this->addElement('open_time', _AD_DISCUSS_LANG_OPENTIME, 150, array('method'=>'time2str', 'format'=>'m/d H:i'));
		$this->addElement('close_time', _AD_DISCUSS_LANG_CLOSETIME, 150, array('method'=>'time2str', 'format'=>'m/d H:i'));
		$this->addElement('closed', _AD_DISCUSS_LANG_ISCLOSED, 50, array('sort'=>true, 'filter'=>true, 'method'=>'key2val', 'var_arr'=>array(0=>_NO,1=>_YES)));
		$this->addElement('perm_type', _AD_DISCUSS_LANG_PERMTYPE, 150, array('sort'=>true, 'filter'=>true, 'method'=>'key2val', 'var_arr'=>array(0=>_AD_DISCUSS_LANG_ALOWALL, 1=>_AD_DISCUSS_LANG_EXCEPTGUEST, 2=>_AD_DISCUSS_LANG_SPECIFIED)));
		$this->addElement('__SimpleEditLink__', '', 50);
		$this->addElement('__SimpleDeleteLink__', '', 50);
		$this->addElement('ajax_test', '', 50, array('extraVar'=>'Ajax test', 'link'=>$_SERVER['SCRIPT_NAME'].'/test?'));
	}

	function getSelf() {
		return DISCUSS_URL . '/admin/index.php/discussion';
	}
}

class DiscussDiscussionAdminForm extends XoopsTableObjectForm
{
	function DiscussDiscussionAdminForm()
	{
		$this->setPrefix('discuss');
	}

	function prepare(&$object)
	{
		if ($object->getVar('discuss_id')) {
			$this->addElement('discuss_id', 'Hidden', '', 0);
		}
		$this->addElement('subject', 'Text', _AD_DISCUSS_LANG_AGENDA, array('maxlength'=>120));
		$this->addElement('description', 'TextArea', _AD_DISCUSS_LANG_DESCRIPTION);

		$this->addElement('time_desc', 'Label', '', _AD_DISCUSS_LANG_TIMEDESC);
		$time = $object->getVar('open_time');
		if ($time > 0) {
			$time = formatTimestamp($time, 'Y-m-d H:i:s');
		}
		$this->addElement('open_time', 'Text', _AD_DISCUSS_LANG_OPENTIME, array('size' => 30, 'value' => $time));

		$time = $object->getVar('close_time');
		if ($time > 0) {
			$time = formatTimestamp($time, 'Y-m-d H:i:s');
		}
		$this->addElement('close_time', 'Text', _AD_DISCUSS_LANG_CLOSETIME, array('size' => 30, 'value' => $time));

		$this->addElement('closed', 'RadioYN', _AD_DISCUSS_LANG_ISCLOSED);
		$this->addElement('perm_type', 'Select', _AD_DISCUSS_LANG_PERMTYPE);
		$this->addOptionArray('perm_type', array(0=>_AD_DISCUSS_LANG_ALOWALL, 1=>_AD_DISCUSS_LANG_EXCEPTGUEST, 2=>_AD_DISCUSS_LANG_SPECIFIED));
	}
}

class DiscussDiscussionAdminController extends XoopsSimpleAdminController
{
	function DiscussDiscussionAdminController()
	{
		parent::XoopsSimpleAdminController('DiscussDiscussion', _AD_DISCUSS_LANG_DISCUSS);
		$this->setJoin2List('discuss_message', 'discuss_id', 'discuss_id');
		$this->groupby = $GLOBALS['xoopsDB']->prefix('discuss').'.discuss_id';
		$this->url = DISCUSS_URL . '/admin/index.php/discussion';
	}
}
?>