<?php
require_once DISCUSS_PATH . '/class/permission.php';
require_once DISCUSS_PATH . '/class/general/xoopssimplecontroller.php';

class DiscussPermissionAdminList extends XoopsTableObjectList
{
	function DiscussPermissionAdminList()
	{
		$this->addElement('discuss_id', 'discuss', 100, array('sort'=>true, 'filter'=>true, 'method'=>'id2name', 'class'=>'discussion'));
		$this->addElement('uid', 'user', 20, array('sort'=>true, 'filter'=>true, 'method'=>'uid2name'));
		$this->addElement('perm', 'permission', 100, array('method'=>'key2val', 'var_arr'=>array(0=>'deny',1=>'allow')));
		$this->addElement('__SimpleEditLink__', '', 50);
		$this->addElement('__SimpleDeleteLink__', '', 50);
	}

	function getSelf() {
		return DISCUSS_URL . '/admin/index.php/permission';
	}
}

class DiscussPermissionAdminForm extends XoopsTableObjectForm
{
	function DiscussPermissionAdminForm()
	{
		$this->setPrefix('discuss_perm');
	}

	function prepare(&$object)
	{
		if ($object->getVar('discuss_id') == null) {
			$this->addElement('discuss_id', 'Select', 'discuss');
			$discussion_handler =& Discuss::gethandler('discussion');
			$discussion_objects =& $discussion_handler->getObjects();
			foreach ($discussion_objects as $obj) {
				$discussions[$obj->getVar('discuss_id')] = $obj->getVar('subject');
			}
			$this->addOptionArray('discuss_id', $discussions);
		} else {
			$this->addElement('discuss_id', 'Hidden');
			$discussion_handler =& Discuss::gethandler('discussion');
			$discussion =& $discussion_handler->get($object->getVar('discuss_id'));
			if ($discussion) {
				$subject = $discussion->getVar('subject');
			} else {
				$subject = 'Error';
			}
			$this->addElement('discuss_id_label', 'Label', 'discuss', $subject);
		}
		if ($object->getVar('uid') == null) {
			$this->addElement('uid', 'SelectUser', 'user');
		} else {
			$this->addElement('uid', 'Hidden');
			$member_handler =& xoops_gethandler('member');
			$user =& $member_handler->getUser($object->getVar('uid'));
			if ($user) {
				$uname = $user->getVar('uname');
			} else {
				$uname = 'Error';
			}
			$this->addElement('uid_label', 'Label', 'user', $uname);
		}
		$this->addElement('perm', 'RadioYN', 'allow access?');
	}
}

class DiscussPermissionAdminController extends XoopsSimpleAdminController
{
	function DiscussPermissionAdminController()
	{
		parent::XoopsSimpleAdminController('DiscussPermission', _AD_DISCUSS_LANG_PERMISSION);
		$this->allowedOp[] = 'deleteall';
		$this->allowedOp[] = 'deleteallok';
		$this->url = DISCUSS_URL . '/admin/index.php/permission';
	}
}
?>