<?php
/**
 * @version $Id$
 */
if (!class_exists('DiscussAttendee')) {
require_once DISCUSS_PATH . '/class/general/xoopstableobject.php';

class DiscussAttendee extends XoopsTableObject
{
	function DiscussAttendee()
	{
		// call parent constructor
		$this->XoopsTableObject();

		// define object elements
		$this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('sess_id', XOBJ_DTYPE_TXTBOX, null, true, 32);
		$this->initVar('uid', XOBJ_DTYPE_INT, null, true);
		$this->initVar('uname', XOBJ_DTYPE_TXTBOX, null, true, 60);
		$this->initVar('updated', XOBJ_DTYPE_INT, null, true);
		$this->initVar('status', XOBJ_DTYPE_INT, null, true);

		// define primary key
		$this->setKeyFields(array('discuss_id','sess_id'));
	}
}

class DiscussAttendeeHandler extends XoopsTableObjectHandler
{
	/**
	 * database table name
	 *
	 * @var string
	 */
	var $tableName = "discuss_attendee";
	
	/**
	 * interval of stay action
	 *
	 * @var int
	 */
	var $_stayInterval;

	function DiscussAttendeeHandler($db)
	{
		parent::XoopsTableObjectHandler($db);
		$this->_stayInterval = DISCUSS_STAY_INTERVAL + 6;
	}

	/**
	 * return objects that include infomation of attendee in the discussion.
	 * 
	 * @return array array containing attendee objects.
	 */
	function &getActiveAttendee()
	{
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria("status", 1));
		$criteria->add(new Criteria('updated', time() - $this->_stayInterval, '>='));

		return $this->getObjects($criteria, true);
	}

	/**
	 * delete records that 8 hour past
	 *
	 * @return boolean
	 */
	function garbageCollect()
	{
		$criteria =& new CriteriaCompo();
		//28800 = 8 * 60 * 60
		$criteria->add(new Criteria('updated', time() - 28800, '<'));

		return $this->deleteAll($criteria, true);
	}
}
}//end of if
?>