<?php
/**
 * Join to discussion
 *
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussControllerJoin extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerJoin()
    {
        $this->_control = 'join';

        $this->context =& new DiscussGeneralContext();
        $this->context->accept('discuss_id', 'discuss_id');
        if (empty($_SESSION['discussUname'])) {
            $this->context->accept('guestname', 'guestname', 'string');
        }
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        //check validity of discussion
        $handler_discussion =& $this->load('discussion');
        if (!$discussion =& $handler_discussion->get($this->context)) {
            $this->errorMsg = $handler_discussion->getErrors();
            return false;
        }

        //check user permision
        $handler_user =& $this->load('user', 'lib');
        $user =& $handler_user->create($this->context);

        if (!$this->checkPermission($discussion, $user)) {
            return false;
        }

        $attendee =& $this->load('attendee');

        if (!$discussion->isOpen()) {
            $view->set('uname', '');
            $view->set('message', _MD_DISCUSS_CLOSED);
            return $attendee->join($this->context, $user, 0);
        }

        //join process
        if (!$attendee->join($this->context, $user)) {
            $this->errorMsg = $attendee->getErrors();
            return false;
        }

        //notify that I'm now join to members
        $member =& $this->load('member', 'view');
        $member->set('x', 'J');
        $member->set('sess_id', session_id());
        $member->set('uname', $user->get('uname'));

        if (!$handler_discussion->cache($this->context, $member, $view)) {
            $this->errorMsg = $handler_discussion->getErrors();
            return false;
        }

        //view
        $view->incArray('attendee');
        $attendee->assign($view, $this->context);
        $view->endArray();

        $view->setEnv(DISCUSS_DATE_LONG, $user->get('timeoffset'));
        $view->incArray('message');
        $message =& $this->load('message');
        $message_limit = isset($GLOBALS['xoopsModuleConfig']['message_limit']) ? $GLOBALS['xoopsModuleConfig']['message_limit'] : 10;
        $message->assign($view, $this->context, $message_limit);
        $view->endArray();

        return true;
    }
}
?>