<?php
/**
 * @version $Id$
 */
require_once DISCUSS_PATH . '/class/message.php';
require_once DISCUSS_PATH . '/class/general/xoopssimplecontroller.php';

class DiscussMessageList extends XoopsTableObjectList
{
	function DiscussMessageList()
	{
		$this->addElement('message_id', 'No', 1);
		$this->addElement('uname', _POSTEDBY, 100);
		$this->addElement('message',  _MD_DISCUSS_MESSAGE, 500);
		$this->addElement('timestamp',  _MD_DISCUSS_DATE, 100, array('method'=>'time2str', 'format'=>DISCUSS_DATE_LONG));
	}

	function getSelf() {
		return DISCUSS_URL . '/index.php/log';
	}
}

class DiscussControllerLog extends XoopsSimpleMainController
{
	function DiscussControllerLog()
	{
		parent::XoopsSimpleMainController('DiscussMessage', 'discuss_log', _MD_DISCUSS_READLOG);
		$this->setJoin2List('discuss', 'discuss_id', 'discuss_id', 'INNER');
		$this->op = 'list';
		$this->url = DISCUSS_URL . '/index.php/log';

		if (empty($_GET["discuss_id"])) {
			redirect_header(XOOPS_URL.'/modules/discuss/', 1, _MD_DISCUSS_NODISCUSSION);
		}
		$this->checkPermission();

		if (empty($_GET['start'])) {
			$this->showRecent();
		}
	}

	function showRecent()
	{
		$message_handler =& xoops_getmodulehandler('message');
		$criteria = new Criteria('discuss_id', intval($_GET['discuss_id']));
		$count = $message_handler->getCount($criteria);

		$start = 0;
		$perpage = 30;
		if ($count > $perpage) {
			$start = intval(($count - 1) / $perpage) * $perpage ;
		}
		$this->start = $start;
	}

	function checkPermission()
	{
		$discuss_id = intval($_GET['discuss_id']);
		$discussion_handler =& Discuss::getHandler('discussion');
		if (!$discussion =& $discussion_handler->get($discuss_id)) {
			redirect_header(XOOPS_URL.'/modules/discuss/', 1, _MD_DISCUSS_NODISCUSSION);
		}

		$perm_type = $discussion->getVar('perm_type');
		if (is_object($GLOBALS['xoopsUser'])) {
			if ($perm_type == 2) {
				$permission_handler =& Discuss::getHandler('permission');
				if (!$permission_handler->get(array('discuss_id'=>$discuss_id, 'uid'=>$GLOBALS['xoopsUser']->getVar('uid')))) {
					redirect_header(XOOPS_URL.'/modules/discuss/', 1, _NOPERM);
				}
			}
		} elseif ($perm_type > 0) {
			redirect_header(XOOPS_URL.'/modules/discuss/', 1, _NOPERM);
		}
	}
}
?>