<?php
/**
 * @version $Id$
 */
class DiscussControllerMain
{
	function DiscussControllerMain()
	{
	}

	function execute()
	{
		require_once DISCUSS_PATH .'/class/view/properties.php';
		$properties =& new DiscussViewProperties();
		$properties->set('stay_frequency', DISCUSS_STAY_INTERVAL);

		if (is_object($GLOBALS['xoopsUser'])) {
			$permission_handler =& Discuss::getHandler('permission');
			$permitted_discuss_ids = $permission_handler->getPermittedDiscussIds($GLOBALS['xoopsUser']->getVar('uid'));
		} else {
			$permitted_discuss_ids = null;
			if (!isset($_SESSION['discussUname'])) {
				$properties->set('nobody', _MD_DISCUSS_WELCOME);
			}
		}

		$discussion_handler =& Discuss::getHandler('discussion');
		$discussions =& $discussion_handler->getDiscussions($permitted_discuss_ids);

		$properties->incObject('discussion');

		$records = array();
		foreach ($discussions as $discuss_id => $discussion) {

			$records[$discuss_id] = array();
			$records[$discuss_id]['subject'] = $discussion->getVar('subject');
			$records[$discuss_id]['description'] = $discussion->getVar('description');
			$records[$discuss_id]['log'] = DISCUSS_URL .'/index.php/log?discuss_id='. $discuss_id;

			$close_time = $discussion->getVar('close_time');
			if ($discussion->getVar('closed')
			 || ($close_time <= time() && $close_time > 0)) {
				$records[$discuss_id]['closed'] = true;
				$records[$discuss_id]['notice'] = '('. _MD_DISCUSS_CLOSED .')';
			} else {
				$open_time = $discussion->getVar('open_time');
				if ($open_time < time()) {
					$records[$discuss_id]['closed'] = false;
					if ($close_time > 0) {
						$records[$discuss_id]['notice'] = sprintf(_MD_DISCUSS_UNTIL, formatTimestamp($close_time, DISCUSS_DATE_LONG));
					}
				} else {
					$records[$discuss_id]['closed'] = true;
					$records[$discuss_id]['notice'] = sprintf(_MD_DISCUSS_FROM, formatTimestamp($open_time, DISCUSS_DATE_LONG));
				}
			}
			$properties->setD($discuss_id, $records[$discuss_id]['subject']);
		}
		$properties->endObject();
		if (count($records) == 1) {
			$properties->set('discuss_id', $discuss_id);
		}

		$colors = isset($GLOBALS['xoopsModuleConfig']['colors']) ? $GLOBALS['xoopsModuleConfig']['colors'] : array();
		if (count($colors) == 1 && $colors[0] == '') {
			$colors = array();
		}

		$GLOBALS['xoopsTpl']->assign('properties', $properties->getResult());
		$GLOBALS['xoopsTpl']->assign('records', $records);
		$GLOBALS['xoopsTpl']->assign('colors', $colors);
		$GLOBALS['xoopsTpl']->assign('discuss_version', $GLOBALS['xoopsModule']->getInfo('version'));

		$this->setHeader();
		$this->garbageCollect();
	}

	function garbageCollect()
	{

		if (mt_rand(1, 100) < 11) {
			$attendee_handler =& Discuss::getHandler('attendee');
			$attendee_handler->garbageCollect();
		}
	}

	function setHeader()
	{
		$stylesheets = array();
		$stylesheets['discuss'] = '/resource/css/discuss.css';
		$stylesheets['niftyCorners'] = '/resource/css/niftyCorners.css';

		$javascripts = array();
		$javascripts['prototype'] = '/resource/js/prototype-1.6.0.2.js';
		$javascripts['discuss'] = '/resource/js/discuss.js';
		$javascripts['niftycube'] = '/resource/js/niftycube.js';

		//user definition
		if (file_exists(DISCUSS_PATH . '/settings/custom.ini.php')) {
			require DISCUSS_PATH . '/settings/custom.ini.php';
		}

		$moduleHeader = $GLOBALS['xoopsTpl']->get_template_vars('xoops_module_header');
		foreach ($stylesheets as $css) {
			$moduleHeader .= '<link rel="stylesheet" type="text/css" media="all" href="' . DISCUSS_URL . $css . '" />' . "\n";
		}
		foreach ($javascripts as $js) {
			$moduleHeader .= '<script type="text/javascript" charset="utf-8" src="' . DISCUSS_URL . $js . '"></script>' . "\n";
		}

		$GLOBALS['xoopsTpl']->assign('xoops_module_header', $moduleHeader);
	}
}
?>