<?php
/**
 * Open to discussion
 *
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussControllerOpen extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerOpen()
    {
        $this->_control = 'open';

        $this->context =& new DiscussGeneralContext();
        $this->context->accept('discuss_id', 'discuss_id');
        $this->context->accept('start', 's');
        $this->context->accept('prev', 'p');
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        //check validity of discussion
        $handler_discussion =& $this->load('discussion');
        if (!$discussion =& $handler_discussion->get($this->context)) {
            $this->errorMsg = $handler_discussion->getErrors();
            return false;
        }

        //check user permision
        $handler_user =& $this->load('user', 'lib');
        $user =& $handler_user->create($this->context);
        if (!$this->checkPermission($discussion, $user)) {
            return false;
        }

        //join process
        $attendee =& $this->load('attendee');
        if (!$attendee->join($this->context, $user, 0)) {
            $this->errorMsg = $attendee->getErrors();
            return false;
        }

        $message =& $this->load('message');

        $view->setEnv(DISCUSS_DATE_LONG, $user->get('timeoffset'));
        $view->incArray('message');
        $message->assign($view, $this->context);
        $view->endArray();

        $view->incObject('days');
        $message->assignDays($view, $this->context);
        $view->endObject();

        return true;
    }
}
?>